/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */
/*
 * @brief  GPIO ISR
 */
#if USING_VECTOR_INTERRUPT != 0
__INTERRUPT void GPIO_IRQHandler(void)
{
    SAVE_IRQ_CSR_CONTEXT(); // Save interrupt context

    // Check if the interrupt is triggered by AIO2
    if (GpioIntRegs.AIO_INTSTATUS.bit.AIO2 == 1) {
        GpioDataRegs.AIOTOGGLE.bit.AIO4 = 0x1; // Toggle AIO4 state

        // Clear the interrupt flag for AIO2
        GpioIntRegs.AIO_INTCLR.bit.AIO2 = 1;
        GpioIntRegs.AIO_INTCLR.bit.AIO2 = 0;
    }

    RESTORE_IRQ_CSR_CONTEXT(); // Restore interrupt context
}
#else
void GPIO_IRQHandler(void)
{
    // Check if the interrupt is triggered by AIO2
    if (GpioIntRegs.AIO_INTSTATUS.bit.AIO2 == 1) {

        // Toggle AIO4 state
        GpioDataRegs.AIOTOGGLE.bit.AIO4 = 0x1;

        // Clear the interrupt flag for AIO2
        GpioIntRegs.AIO_INTCLR.bit.AIO2 = 1;
        GpioIntRegs.AIO_INTCLR.bit.AIO2 = 0;
    }
}
#endif

void myAIOInputInterrupt_init()
{
    // Configure AIO2 input with synchronized qualification
    GpioCtrlRegs.AIOQSEL1.bit.AIO2 = GPIO_QUAL_SYNC;

    // Enable the AIO2 digital function
    GpioCtrlRegs.AIOMUX1.bit.AIO2 = AIO_MUX1_IO_ENABLED;

    // Set AIO2 as an input pin
    GpioCtrlRegs.AIODIR.bit.AIO2 = GPIO_DIR_MODE_IN;

    // Set AIO2 to trigger interrupt on edge detection
    GpioIntRegs.AIO_INTTYPE.bit.AIO2 = GPIO_INTTYPE_EDGE;

    // Set AIO2 to trigger interrupt on rising edge (positive edge)
    GpioIntRegs.AIO_INTPOL.bit.AIO2 = GPIO_INTPOL_POS_EDGE; // Trigger interrupt on rising edge

    // Clear the interrupt flag for AIO2
    GpioIntRegs.AIO_INTCLR.bit.AIO2 = 1;
    GpioIntRegs.AIO_INTCLR.bit.AIO2 = 0;

    // Unmask the interrupt for AIO2 (allow the interrupt to trigger)
    GpioIntRegs.AIO_INTMASK.bit.AIO2 = GPIO_INTMASK_UNMASK;
}

void myAIOOutput_init()
{
    // Configure AIO4 output with synchronized qualification
    GpioCtrlRegs.AIOQSEL1.bit.AIO4 = GPIO_QUAL_SYNC;

    // Clear any previous data on AIO4
    GpioDataRegs.AIOCLEAR.bit.AIO4 = 0x1;

    // Enable the AIO4 digital function
    GpioCtrlRegs.AIOMUX1.bit.AIO4 = AIO_MUX1_IO_ENABLED;

    // Set AIO4 as an output pin
    GpioCtrlRegs.AIODIR.bit.AIO4 = GPIO_DIR_MODE_OUT;
}

void AIO_init()
{
    // Initialize AIO input with interrupt configuration
    myAIOInputInterrupt_init();

    // Initialize AIO output configuration
    myAIOOutput_init();
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief  main function.
 */
int main(void)
{
    // Initialize the device
    Device_init();

    // Initialize AIO input and output configurations
    AIO_init();

    // Register the GPIO interrupt handler for AIO2
    Interrupt_register(INT_GPIO, GPIO_IRQHandler);

    // Enable the interrupt for GPIO (AIO2)
    Interrupt_enable(INT_GPIO);

    // Enable global interrupts
    __enable_irq();

    while (1) {
    }

    return 0; // Return 0 to indicate successful execution
}
