/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "printf.h"
#include "log.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */
uint32_t gpio_IQR=0;
volatile uint32_t coreTicks = 0;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

void GPIO_Test3_Init(void);

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */
/*
 * \brief  CPUTimer1 ISR
 */
void TIMER1_IRQHandler(void)
{
    CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
    coreTicks += 1;
    if(coreTicks % 4 == 0)
    {
    	GPIO_togglePin(8);
    }
    else if(coreTicks % 4 == 1)
    {
    	GPIO_togglePin(9);
    }
    else if(coreTicks % 4 == 2)
	{
		GPIO_togglePin(10);
    }
    else
	{
		GPIO_togglePin(11);
    }
    __DSB();
}

/*
 * \brief  CPUTimer1 initialization
 */
int32_t timer1_init(uint32_t period)
{
    CPUTimer_init(CPUTIMER1_BASE, period);

    Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
    Interrupt_enable(INT_TIMER1);

    return 0;
}

void APB_GPIO0_CMBINTR_IRQn(void)
{
	gpio_IQR = GPIO_getPortInterruptStatus(GPIO_PORTA_L);
	if(GPIO_getPinInterruptStatus(0))
	{

		GPIO_togglePin(4);
		GPIO_InterruptClear(0);
	}
	if(GPIO_getPinInterruptStatus(1))
	{

		GPIO_togglePin(5);
		GPIO_InterruptClear(1);
	}
	if(GPIO_getPinInterruptStatus(2))
	{

		GPIO_togglePin(6);
		GPIO_InterruptClear(2);
	}
	if(GPIO_getPinInterruptStatus(3))
	{

		GPIO_togglePin(7);
		GPIO_InterruptClear(3);
	}
	/* Make sure the int flag clear is completed */
	__DSB();
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/**
  * @brief  Main program
  * @param  None
  * @retval None
  */
int main(void)
{
	Device_init();

    UartPrint_init(SCIA_BASE, 115200);

	printf("gpio_test3_begin!\r\n");

    timer1_init(DEVICE_APBCLK_FREQ/100);  //10ms

    GPIO_Test3_Init();

    __enable_irq();

	while(1)
	{
	}
}

void GPIO_Test3_Init()
{

	//GPIO interrupt
    Interrupt_register(INT_GPIO, APB_GPIO0_CMBINTR_IRQn);
    Interrupt_enable(INT_GPIO);

	// set GPIO0 and GPIO1 to rising edge interrupt
	GPIO_setInterruptType(0,GPIO_INT_TYPE_RISING_EDGE);
	GPIO_setInterruptType(1,GPIO_INT_TYPE_RISING_EDGE);
	// set GPIO2 and GPIO3 to falling edge interrupt
	GPIO_setInterruptType(2,GPIO_INT_TYPE_FALLING_EDGE);
	GPIO_setInterruptType(3,GPIO_INT_TYPE_FALLING_EDGE);

	// enable GPIO0,1,2,3 interrupt
	GPIO_enableInterrupt(0);
	GPIO_enableInterrupt(1);
	GPIO_enableInterrupt(2);
	GPIO_enableInterrupt(3);

	// set GPIO4,5,6,7,8,9,10,11 to output mode
	GPIO_setDirectionMode(4,GPIO_DIR_MODE_OUT);
	GPIO_setDirectionMode(5,GPIO_DIR_MODE_OUT);
	GPIO_setDirectionMode(6,GPIO_DIR_MODE_OUT);
	GPIO_setDirectionMode(7,GPIO_DIR_MODE_OUT);
	GPIO_setDirectionMode(8,GPIO_DIR_MODE_OUT);
	GPIO_setDirectionMode(9,GPIO_DIR_MODE_OUT);
	GPIO_setDirectionMode(10,GPIO_DIR_MODE_OUT);
	GPIO_setDirectionMode(11,GPIO_DIR_MODE_OUT);

}

