/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "printf.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */
uint32_t gpio_IQR=0;
volatile uint32_t coreTicks = 0;

volatile uint32_t temp1=0;
volatile uint32_t temp2=0;
volatile uint32_t temp3=0;
volatile uint32_t temp4=0;
volatile uint32_t temp5=0;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

void GPIO_Test3_Init();
void APB_GPIO0_CMBINTR_IRQn(void);

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */
/*
 * \brief  CPUTimer1 ISR
 */
void TIMER1_IRQHandler(void)
{
    CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
    coreTicks += 1;
    if(coreTicks % 4 == 0)
    {
    	GpioPortaRegs.DATAOUT.bit.DATAOUT ^= (1 << (8 % 16));
    }
    else if(coreTicks % 4 == 1)
    {
    	GpioPortaRegs.DATAOUT.bit.DATAOUT ^= (1 << (9 % 16));
    }
    else if(coreTicks % 4 == 2)
	{
    	GpioPortaRegs.DATAOUT.bit.DATAOUT ^= (1 << (10 % 16));
    }
    else
	{
    	GpioPortaRegs.DATAOUT.bit.DATAOUT ^= (1 << (11 % 16));
    }


}

/*
 * \brief  CPUTimer1 initialization
 */
int32_t timer1_init(uint32_t period)
{
    CPUTimer_init(CPUTIMER1_BASE, period);

    Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
    Interrupt_enable(INT_TIMER1);

    return 0;
}

/*
 * \brief  GPIO ISR
 */
void APB_GPIO0_CMBINTR_IRQn(void)
{

	temp5++;
	gpio_IQR = GPIO_getPortInterruptStatus(GPIO_PORTA_L);
	if(GpioPortaRegs.INTSTATUS_CLEAR.bit.INTSTATUS_CLEAR & (1 << (0 % 16)))
	{

		temp1++;
		GpioPortaRegs.DATAOUT.bit.DATAOUT ^= (1 << (4 % 16));
		GpioPortaRegs.INTSTATUS_CLEAR.bit.INTSTATUS_CLEAR = (1 << (0 % 16));
		__DSB();
	}
	if(GpioPortaRegs.INTSTATUS_CLEAR.bit.INTSTATUS_CLEAR & (1 << (1 % 16)))
	{

		temp2++;
		GpioPortaRegs.DATAOUT.bit.DATAOUT ^= (1 << (5 % 16));
		GpioPortaRegs.INTSTATUS_CLEAR.bit.INTSTATUS_CLEAR = (1 << (1 % 16));
		__DSB();
	}
	if(GpioPortaRegs.INTSTATUS_CLEAR.bit.INTSTATUS_CLEAR & (1 << (2 % 16)))
	{
		temp3++;
		GpioPortaRegs.DATAOUT.bit.DATAOUT ^= (1 << (6 % 16));
		GpioPortaRegs.INTSTATUS_CLEAR.bit.INTSTATUS_CLEAR = (1 << (2 % 16));
		__DSB();
	}
	if(GpioPortaRegs.INTSTATUS_CLEAR.bit.INTSTATUS_CLEAR & (1 << (3 % 16)))
	{
		temp4++;
		GpioPortaRegs.DATAOUT.bit.DATAOUT ^= (1 << (7 % 16));
		GpioPortaRegs.INTSTATUS_CLEAR.bit.INTSTATUS_CLEAR = (1 << (3 % 16));
		__DSB();
	}
}

/*
 * \brief  GPIO initialization
 */
void GPIO_Test3_Init()
{

	//GPIO interrupt
    Interrupt_register(INT_GPIO, APB_GPIO0_CMBINTR_IRQn);
    Interrupt_enable(INT_GPIO);


	// set GPIO0 and GPIO1 to rising edge interrupt
    GpioPortaRegs.INTTYPESET.bit.INTTYPESET = GpioPortaRegs.INTTYPESET.all | (1 << (0 % 16));
    GpioPortaRegs.INTPOLSET.bit.INTPOLSET = GpioPortaRegs.INTPOLSET.all | (1 << (0 % 16));

    GpioPortaRegs.INTTYPESET.bit.INTTYPESET = GpioPortaRegs.INTTYPESET.all | (1 << (1 % 16));
    GpioPortaRegs.INTPOLSET.bit.INTPOLSET = GpioPortaRegs.INTPOLSET.all | (1 << (1 % 16));

	// set GPIO2 and GPIO3 to falling edge interrupt
	GpioPortaRegs.INTTYPESET.bit.INTTYPESET = GpioPortaRegs.INTTYPESET.all | (1 << (2 % 16));
	GpioPortaRegs.INTPOLCLR.bit.INTPOLCLR = (1 << (2 % 16));

	GpioPortaRegs.INTTYPESET.bit.INTTYPESET = GpioPortaRegs.INTTYPESET.all | (1 << (3 % 16));
	GpioPortaRegs.INTPOLCLR.bit.INTPOLCLR = (1 << (3 % 16));




	// enable GPIO0,1,2,3 interrupt
	GpioPortaRegs.INTENSET.bit.INTENSET = GpioPortaRegs.INTENSET.all | (1 << (0 % 16));
	GpioPortaRegs.INTENSET.bit.INTENSET = GpioPortaRegs.INTENSET.all | (1 << (1 % 16));
	GpioPortaRegs.INTENSET.bit.INTENSET = GpioPortaRegs.INTENSET.all | (1 << (2 % 16));
	GpioPortaRegs.INTENSET.bit.INTENSET = GpioPortaRegs.INTENSET.all | (1 << (3 % 16));


	// set GPIO4,5,6,7,8,9,10,11 to output mode
	GpioPortaRegs.OUTENSET.bit.OUTENSET = GpioPortaRegs.OUTENSET.all | (1 << (4 % 16));
	GpioPortaRegs.OUTENSET.bit.OUTENSET = GpioPortaRegs.OUTENSET.all | (1 << (5 % 16));
	GpioPortaRegs.OUTENSET.bit.OUTENSET = GpioPortaRegs.OUTENSET.all | (1 << (6 % 16));
	GpioPortaRegs.OUTENSET.bit.OUTENSET = GpioPortaRegs.OUTENSET.all | (1 << (7 % 16));
	GpioPortaRegs.OUTENSET.bit.OUTENSET = GpioPortaRegs.OUTENSET.all | (1 << (8 % 16));
	GpioPortaRegs.OUTENSET.bit.OUTENSET = GpioPortaRegs.OUTENSET.all | (1 << (9 % 16));
	GpioPortaRegs.OUTENSET.bit.OUTENSET = GpioPortaRegs.OUTENSET.all | (1 << (10 % 16));
	GpioPortaRegs.OUTENSET.bit.OUTENSET = GpioPortaRegs.OUTENSET.all | (1 << (11 % 16));
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/**
  * @brief  Main program
  * @param  None
  * @retval None
  */
int main(void)
{
	Device_init();

    UartPrint_init(SCIA_BASE, 115200);

	printf("gpio_test3_begin!\r\n");

    timer1_init(DEVICE_APBCLK_FREQ/100);  //10ms

    GPIO_Test3_Init();

    __enable_irq();


	while(1)
	{
	}
}


