// See LICENSE for license details.
#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"

volatile uint16_t GPIO_PORTH_L_NUM = 0;
volatile uint16_t GPIO_PORTH_H_NUM = 0;

volatile uint32_t dspTicks = 0;
uint32_t gpio_data=0;
volatile uint32_t CPUTME_STS = 0;

uint32_t length_AIO=0;
uint32_t *AIO_INDEX;
uint32_t printf_index = 0;
const uint32_t AIO_INDEX_0039_100PIN[] = {
									224,225,226,227,228,229,230,231,232,233,234,235,
									236,237,238,239,240,
									241,242,243,
									244,245,246,
									247,248,249,250,
									251,252,253,254
};


const uint32_t AIO_INDEX_379_176PIN_QFP[] = {
									225,226,227,228,229,230,231,232,233,234,235,
									236,237,238,239,240,
									241,242
};






void TIMER1_IRQHandler(void)
{
	CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
	dspTicks += 1;
	if(dspTicks % 200 == 0)
	{
		CPUTME_STS = 1 ;
	}
}

int32_t Timer1_init(uint32_t base, uint32_t period)
{
	/* Initialize CPUTimer with interrupt enable */
	CPUTimer_init(CPUTIMER1_BASE, period);

	Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
	Interrupt_enable(INT_TIMER1);

	return 0;
}

uint32_t i=0;



/* Private functions ---------------------------------------------------------*/
/**
  * @brief  Main program
  * @param  None
  * @retval None
  */

int main(void)
{

	Device_init();

    UartPrint_init(SCIA_BASE, 115200);

	printf("gpio_test01_begin!\r\n");

    Timer1_init(CPUTIMER1_BASE, DEVICE_APBCLK_FREQ/100);    //10ms

    __enable_irq();
#if IS_GS32F00xx(0x12)
    AIO_INDEX = (uint32_t *)AIO_INDEX_0039_100PIN;

	length_AIO = sizeof(AIO_INDEX_0039_100PIN)/4;
#elif IS_GS32F3xx(0x22)
    AIO_INDEX = (uint32_t *)AIO_INDEX_379_176PIN_QFP;

	length_AIO = sizeof(AIO_INDEX_379_176PIN_QFP)/4;
#endif

	//AIO Init
	for(i=0;i<length_AIO;i++)
	{
		uint32_t AIO_INDEX_TEMP=0;
		AIO_INDEX_TEMP = AIO_INDEX[i];

		GPIO_setAnalogMode(AIO_INDEX_TEMP,GPIO_ANALOG_DISABLED);//set AIO to digital mode
		GPIO_setInputEnableGPH(AIO_INDEX_TEMP,true);//enable AIO input

	}




	while(1)
	{

            if (CPUTME_STS == 1)
            {
            	uint32_t i ;
            	uint32_t DATA = 0 ;
            	printf("%d*************************************\r\n",printf_index);
            	for(i=0;i<length_AIO;i++)
            	{
            		DATA = GPIO_readPin(AIO_INDEX[i]);// read data pin
            		printf("AIO%d: %d\r\n", AIO_INDEX[i],DATA);
            	}
            	GPIO_PORTH_L_NUM =	GPIO_readPortData(GPIO_PORTH_L);// read data port
            	GPIO_PORTH_H_NUM =	GPIO_readPortData(GPIO_PORTH_H);
				#if IS_GS32F00xx(0x12)
					printf("GPIO_PORTH_L(224-239): %#X\r\n", GPIO_PORTH_L_NUM);
					printf("GPIO_PORTH_H(240-254): %#X\r\n", GPIO_PORTH_H_NUM);
				#elif IS_GS32F3xx(0x22)
					printf("GPIO_PORTH_L(225-239): %#X\r\n", GPIO_PORTH_L_NUM);
					printf("GPIO_PORTH_H(240-242): %#X\r\n", GPIO_PORTH_H_NUM);
				#endif

            	CPUTME_STS = 0;
            	printf_index++;
            }


	}



}


