// See LICENSE for license details.
#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"

volatile uint16_t GPIO_PORTH_L_NUM = 0;
volatile uint16_t GPIO_PORTH_H_NUM = 0;

volatile uint32_t dspTicks = 0;
uint32_t gpio_data=0;

volatile uint32_t CPUTME_STS = 0;

uint32_t length_GPIO=0;
uint32_t length_AIO=0;
uint32_t error_sum=0;
uint32_t *AIO_INDEX;
uint32_t *GPIO_INDEX;
const uint32_t AIO_INDEX_0039_100PIN[] = {
									224,225,226,227,228,229,230,231,232,233,234,235,
									236,237,238,239,240,
									242,241,243,
									244,245,246,
									247,248,249,250,
									251,252,253,254
};


const uint32_t AIO_INDEX_379_176PIN_QFP[] = {
									225,226,227,228,229,230,231,232,233,234,235,
									236,237,238,239,240,
									241,242
};



const uint32_t GPIO_INDEX_0039_100PIN[] = {
									3,2,0,41,7,5,59,34,14,30,47,49,51,53,
									1,40,23,22,44,9,61,10,15,6,31,48,50,52,54,
									4,58,56,27,25,17,33,
									8,57,32,26,24,16,11,
									12,20,55,
									13,21,60
};


const uint32_t GPIO_INDEX_379_176PIN_QFP[] = {

		133,47,68,70,72,74,75,77,79,81,83,84,
		46,67,69,71,73,76,78,80,82,85,
		45,62,64,66,60,58,56,54,52,50,48,41,39,37,35,33,31,29,
		44,63,65,61,59,57,55,53,51,49,40,38,36,34,32,30,28,
		86,0,2,4,6,88,90,92,94,11,13,15,17,19,21,9,23,25,27,
		87,1,3,5,7,89,91,93,10,12,14,16,18,20,8,22,24,26
};

void TIMER1_IRQHandler(void)
{
	CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
	dspTicks += 1;
	if(dspTicks % 200 == 0)
	{
		CPUTME_STS = 1 ;
	}
}

int32_t Timer1_init(uint32_t base, uint32_t period)
{
	/* Initialize CPUTimer with interrupt enable */
	CPUTimer_init(CPUTIMER1_BASE, period);

	Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
	Interrupt_enable(INT_TIMER1);

	return 0;
}

uint32_t i=0;



/* Private functions ---------------------------------------------------------*/
/**
  * @brief  Main program
  * @param  None
  * @retval None
  */

int main(void)
{

	Device_init();

    UartPrint_init(SCIA_BASE, 115200);

	printf("gpio_test5_begin!\r\n");

    Timer1_init(CPUTIMER1_BASE, DEVICE_APBCLK_FREQ/100);    //10ms

    __enable_irq();

#if IS_GS32F00xx(0x12)
    AIO_INDEX = (uint32_t *)AIO_INDEX_0039_100PIN;

    GPIO_INDEX = (uint32_t *)GPIO_INDEX_0039_100PIN;

	length_AIO = sizeof(AIO_INDEX_0039_100PIN)/4;

	length_GPIO = sizeof(GPIO_INDEX_0039_100PIN)/4;
#elif IS_GS32F3xx(0x22)
    AIO_INDEX = (uint32_t *)AIO_INDEX_379_176PIN_QFP;

    GPIO_INDEX = (uint32_t *)GPIO_INDEX_379_176PIN_QFP;

	length_AIO = sizeof(AIO_INDEX_379_176PIN_QFP)/4;

	length_GPIO = sizeof(GPIO_INDEX_379_176PIN_QFP)/4;
#endif



	//AIO Input Polarity Invert Test
	printf("*****************AIO Input Polarity Invert Test***************************\r\n");
	for(i=0;i<length_AIO;i++)
	{
		uint32_t AIO_INDEX_TEMP=0;
		AIO_INDEX_TEMP = AIO_INDEX[i];

		GPIO_setAnalogMode(AIO_INDEX_TEMP,GPIO_ANALOG_DISABLED);//set AIO to digital mode
		GPIO_setInputEnableGPH(AIO_INDEX_TEMP,true);//enable AIO input
		GPIO_setPadConfig(AIO_INDEX_TEMP,GPIO_PIN_TYPE_INVERT);//set GPIO to Input Polarity Invert

		if(GPIO_readPin(AIO_INDEX_TEMP) != 1)
		{
			printf("AIO%d:DATA=%d\r\n",AIO_INDEX_TEMP,GPIO_readPin(AIO_INDEX_TEMP));
			error_sum++;
		}
		//printf("AIO%d:DATA=%d\r\n",AIO_INDEX_TEMP,GPIO_readPin(AIO_INDEX_TEMP));

		GPIO_setPadConfig(AIO_INDEX_TEMP,GPIO_PIN_TYPE_STD);//set GPIO to STD
	}

	GPIO_setAnalogMode(13,GPIO_ANALOG_DISABLED);//set 13 to digital mode
	GPIO_setAnalogMode(20,GPIO_ANALOG_DISABLED);//set 20 to digital mode
	GPIO_setAnalogMode(21,GPIO_ANALOG_DISABLED);//set 21 to digital mode

	//GPIO Input Polarity Invert Test
	printf("*****************GPIO Input Polarity Invert Test***************************\r\n");
	for(i=0;i<length_GPIO;i++)
	{
		uint32_t GPIO_INDEX_TEMP=0;
		GPIO_INDEX_TEMP = GPIO_INDEX[i];

		GPIO_setPadConfig(GPIO_INDEX_TEMP,GPIO_PIN_TYPE_INVERT);//set GPIO to Input Polarity Invert

		if(GPIO_readPin(GPIO_INDEX_TEMP) != 1)
		{
			printf("GPIO%d:DATA=%d\r\n",GPIO_INDEX_TEMP,GPIO_readPin(GPIO_INDEX_TEMP));
			error_sum++;
		}
		//printf("GPIO%d:DATA=%d\r\n",GPIO_INDEX_TEMP,GPIO_readPin(GPIO_INDEX_TEMP));

		GPIO_setPadConfig(GPIO_INDEX_TEMP,GPIO_PIN_TYPE_STD);//set GPIO to STD
	}


	//GPIO Output Polarity Invert Test
	printf("*****************GPIO Output HIGH Polarity Invert Test***************************\r\n");
	for(i=0;i<length_GPIO;i++)
	{
		uint32_t GPIO_INDEX_TEMP=0;
		GPIO_INDEX_TEMP = GPIO_INDEX[i];
		GPIO_setDirectionMode(GPIO_INDEX_TEMP,GPIO_DIR_MODE_OUT);
		GPIO_setOutPolarityInv(GPIO_INDEX_TEMP,true);//set GPIO to Output Polarity Invert
		GPIO_setLoopBack(GPIO_INDEX_TEMP,true);

		GPIO_writePin(GPIO_INDEX_TEMP,1);

		if(GPIO_readPin(GPIO_INDEX_TEMP) != 0)
		{
			printf("GPIO%d:DATA=%d\r\n",GPIO_INDEX_TEMP,GPIO_readPin(GPIO_INDEX_TEMP));
			error_sum++;
		}
//		printf("GPIO%d:DATA=%d\r\n",GPIO_INDEX_TEMP,GPIO_readPin(GPIO_INDEX_TEMP));
	}
	printf("*****************GPIO Output LOW Polarity Invert Test***************************\r\n");
	for(i=0;i<length_GPIO;i++)
	{
		uint32_t GPIO_INDEX_TEMP=0;
		GPIO_INDEX_TEMP = GPIO_INDEX[i];

		GPIO_writePin(GPIO_INDEX_TEMP,0);

		if(GPIO_readPin(GPIO_INDEX_TEMP) != 1)
		{
			printf("GPIO%d:DATA=%d\r\n",GPIO_INDEX_TEMP,GPIO_readPin(GPIO_INDEX_TEMP));
			error_sum++;
		}
		//printf("GPIO%d:DATA=%d\r\n",GPIO_INDEX_TEMP,GPIO_readPin(GPIO_INDEX_TEMP));

		GPIO_setOutPolarityInv(GPIO_INDEX_TEMP,false);//close GPIO to Output Polarity Invert

	}

	if (error_sum==0)
	{
		printf("gpio_test5_ok!\r\n");
	}
	else
	{
		printf("gpio_test5_error!\r\n");
	}


	while(1)
	{

            if (CPUTME_STS == 1)
            {

            }


	}



}


