// See LICENSE for license details.
#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"


volatile uint32_t dspTicks = 0;
uint32_t gpio_data=0;


void TIMER1_IRQHandler(void)
{
	CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
	dspTicks += 1;
	if(dspTicks % 200 == 0)
	{
		GPIO_togglePin(0);
	}
}

int32_t Timer1_init(uint32_t base, uint32_t period)
{
	/* Initialize CPUTimer with interrupt enable */
	CPUTimer_init(CPUTIMER1_BASE, period);

	Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
	Interrupt_enable(INT_TIMER1);

	return 0;
}

int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;

    Device_init();

    UartPrint_init(SCIA_BASE, 115200);

    printf("gpio_ex6_Loopback  test  begin!\r\n");

	GPIO_enableWritePin(0);//set gpio0 to output mode
	GPIO_setLoopBack(0,true);//gpio0 Loopback enable

    Timer1_init(CPUTIMER1_BASE, DEVICE_APBCLK_FREQ/100);    //10ms

    __enable_irq();

    oldTicks = dspTicks;

    while (1)
    {
        if (dspTicks != oldTicks)
        {
            oldTicks = dspTicks;
            tickCnt += 1;

            if ((tickCnt % 100) == 0) {
            	gpio_data = GPIO_readPin(0);
                printf("gpio0_data: %d\r\n", gpio_data);
            }
        }

    }

    return 0;
}

