// See LICENSE for license details.
#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"


void GPIO_test08_initEPWM(void);
void INTERRUPT_init(void);
void ECAP1_IRQHandler(void);
void myECAP0_init(void);
void myINPUTXBARINPUT0_init(void);
void GPIO_test08_initEPWM(void);

volatile uint32_t dspTicks = 0;
volatile uint32_t CPUTME_STS = 0;
volatile uint32_t GPIO_A_STS = 0;
volatile uint32_t PIN_STS = 0;
vuint16_t epwm1PeriodCount;

void GPIO_Init();
#define myECAP1_BASE    ECAP1_BASE
#define myEPWM0_BASE EPWM2_BASE

#define PRD_VAL  510*5+1  // Calculate value period value
       	   	   	   	   	   	   	   	   	   // for up-down count mode


#define myINPUTXBARINPUT0_SOURCE 0
#define myINPUTXBARINPUT0_INPUT XBAR_INPUT1

#define INT_myECAP0 INT_ECAP1


//
// EPWM1 -> myEPWM1 Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 2
#define myEPWM1_EPWMA_GPIO 2
#define myEPWM1_EPWMA_PIN_CONFIG  GPIO_2_EPWM2_A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 3
#define myEPWM1_EPWMB_GPIO 3
#define myEPWM1_EPWMB_PIN_CONFIG  GPIO_3_EPWM2_B





int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;

    Device_init();

    UartPrint_init(SCIA_BASE, 115200);

    INTERRUPT_init();

    __enable_irq();

    GPIO_Init();

    myECAP0_init();

    myINPUTXBARINPUT0_init();

    GPIO_test08_initEPWM();

    while (1)
    {

    }

}



void myECAP0_init(void)
{

	//
	// Disable ,clear all capture flags and interrupts
	//
	ECAP_disableInterrupt(myECAP1_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	ECAP_clearInterrupt(myECAP1_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));

	// Disables time stamp capture.

	ECAP_disableTimeStampCapture(myECAP1_BASE);

	// Stops Time stamp counter.

	ECAP_stopCounter(myECAP1_BASE);

	// Sets eCAP in Capture mode.

	ECAP_enableCaptureMode(myECAP1_BASE);

	// Sets the capture mode.

	ECAP_setCaptureMode(myECAP1_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_1);

	// Sets the Capture event prescaler.

	ECAP_setEventPrescaler(myECAP1_BASE, 0U);

	// Sets the Capture event polarity.

	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_1,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_2,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_3,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_4,ECAP_EVENT_RISING_EDGE);

	// Configure counter reset on events

	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_1);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_2);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_3);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_4);

	// Select eCAP input.

	ECAP_selectECAPInput(myECAP1_BASE,ECAP_INPUT_INPUTXBAR1);

	// Sets a phase shift value count.

	ECAP_setPhaseShiftCount(myECAP1_BASE,0U);

	// Enable counter loading with phase shift value.

	ECAP_disableLoadCounter(myECAP1_BASE);

	// Configures Sync out signal mode.

	ECAP_setSyncOutMode(myECAP1_BASE,ECAP_SYNC_OUT_SYNCI);

	// Configures emulation mode.

	ECAP_setEmulationMode(myECAP1_BASE,ECAP_EMULATION_STOP);

	// Set up the source for sync-in pulse..

//	SysCtl_setECAPSyncInPulseSource(myECAP1_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);

	// Starts Time stamp counter for myECAP0.

	ECAP_startCounter(myECAP1_BASE);

	// Enables time stamp capture for myECAP0.

	ECAP_enableTimeStampCapture(myECAP1_BASE);

	// Re-arms the eCAP module for myECAP0.

	ECAP_reArm(myECAP1_BASE);

	// Enables interrupt source for myECAP0.

	ECAP_enableInterrupt(myECAP1_BASE,ECAP_ISR_SOURCE_CAPTURE_EVENT_1);

	ECAP_setDBFilterCfg(myECAP1_BASE,0x03);
}


// OUTPUTXBAR Configurations for ECAP1 output
void myINPUTXBARINPUT0_init(void)
{
//	CLB_configOutputLUT(CLB1_BASE, CLB_OUT0, 0X550018);
//	CLB_enableCLB(CLB1_BASE);

	XBAR_setInputPin(INPUTXBAR_BASE,myINPUTXBARINPUT0_INPUT, myINPUTXBARINPUT0_SOURCE);
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,XBAR_OUTPUT1, XBAR_OUT_MUX01_INPUTXBAR1 );
	XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1, XBAR_MUX01);
}

// INTERRUPT Configurations
void INTERRUPT_init(void)
{
	Interrupt_SetPriorityGrouping(0);
  	Interrupt_SetPriority(INT_myECAP0,0,0);
  	Interrupt_register(INT_myECAP0,ECAP1_IRQHandler);
  	Interrupt_enable(INT_myECAP0);
}


void GPIO_Init(void)
{

	GPIO_setQualificationMode(0,GPIO_QUAL_6SAMPLE);//Set
	GPIO_setQualificationPeriod(0,510);//Period:(0-255)*2



	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	//GPIO_setLoopBack(myEPWM1_EPWMA_GPIO,true);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);
	//GPIO 8
	GPIO_setPinConfig(GPIO_24_OUTPUTXBAR1);

}

void GPIO_test08_initEPWM(void)
{
    //
    // Set phase shift to 0 and clear the time base counter
    //
    EPWM_setPhaseShift(myEPWM0_BASE, 0);
    EPWM_setTimeBaseCounter(myEPWM0_BASE, 0);

    //
    // Disable the shadow load; the load will be immediate instead
    //
    EPWM_disableCounterCompareShadowLoadMode(myEPWM0_BASE,
                                             EPWM_COUNTER_COMPARE_A);
    EPWM_disableCounterCompareShadowLoadMode(myEPWM0_BASE,
                                             EPWM_COUNTER_COMPARE_B);

    //
    // Set the compare A value to half the period value, compare B to 0
    //
    EPWM_setCounterCompareValue(myEPWM0_BASE, EPWM_COUNTER_COMPARE_A, PRD_VAL/2);
    EPWM_setCounterCompareValue(myEPWM0_BASE, EPWM_COUNTER_COMPARE_B, 0);

    //
    // Set action qualifier behavior on compare A events
    // - EPWM1A --> 1 when CTR = CMPA and increasing
    // - EPWM1A --> 0 when CTR = CMPA and decreasing
    //
    EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
								  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
								  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

    //
    // Set action qualifier behavior on compare B events
    // - EPWM1B --> 1 when CTR = PRD and increasing
    // - EPWM1B --> 0 when CTR = 0 and decreasing
    //
    EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

    //
    // Enable interrupt when the counter is equal to PRD
    //
    EPWM_setInterruptSource(myEPWM0_BASE, EPWM_INT_TBCTR_PERIOD);
    EPWM_enableInterrupt(myEPWM0_BASE);

    //
    // Interrupt on first event
    //
    EPWM_setInterruptEventCount(myEPWM0_BASE, 1);

    //
    // Set the time base clock prescaler to /1
    //
    EPWM_setClockPrescaler(myEPWM0_BASE, EPWM_CLOCK_DIVIDER_1,
                           EPWM_HSCLOCK_DIVIDER_1);

    //
    // Set the period value; don't shadow the register
    //
    EPWM_setPeriodLoadMode(myEPWM0_BASE, EPWM_PERIOD_DIRECT_LOAD);
    EPWM_setTimeBasePeriod(myEPWM0_BASE, PRD_VAL);

    //
    // Put the time base counter into up-down count mode
    //
    EPWM_setTimeBaseCounterMode(myEPWM0_BASE, EPWM_COUNTER_MODE_UP_DOWN);

    SysCtl_enablePeripheral_TBCLKSYNC();



}

// ECAP Interrupt handler
void ECAP1_IRQHandler(void)
{



    epwm1PeriodCount = EPWM_getTimeBaseCounterValue(myEPWM0_BASE);



    // Clear interrupt flags for more interrupts.

    ECAP_clearInterrupt(myECAP1_BASE,ECAP_ISR_SOURCE_CAPTURE_EVENT_1);
    ECAP_clearGlobalInterrupt(myECAP1_BASE);

    // Start eCAP

    ECAP_reArm(myECAP1_BASE);

}


