/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "hrpwm_ex03_board.h"
#include "cpu.h"
#include "epwm.h"
#include "hrpwm.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


#define   EPWM_MODE_SEL    EPWM_MODE_SPWM_0

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

#include "SFO_v2.h"

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

#define temp_duty 0.0001	//0.1%
#define	PWM1_PRD	999
float32_t PWM1_duty;

SFO_Params_t SFO_ParamsStruct;
uint16_t status;
/* None */
/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;

	PinMux_init();
	EPWM_init();
	//1msһ
	InitTimerModule(DEVICE_APBCLK_FREQ/100);
	EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

}


//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM_init(){

	//PWM1A ߾

	HRPWM_setClockPrescaler(myEPWM1_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	EPWM_setTimeBasePeriod(myEPWM1_BASE, PWM1_PRD);
	HRPWM_setTimeBaseCounter(myEPWM1_BASE, 0);
	HRPWM_setTimeBaseCounterMode(myEPWM1_BASE, EPWM_COUNTER_MODE_UP);
	EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, 0);
	EPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	//ǷԶģʽ
	if(AUTO == 1){
		HRPWM_enableAutoConversion(myEPWM1_BASE);
	}
	else if(AUTO == 0){
		HRPWM_disableAutoConversion(myEPWM1_BASE);
	}

	//debugͣʱPWMС
	EPWM_setEmulationMode(myEPWM1_BASE, 2);
	//ʹУ׼
	HRPWM_enableCalibration(myEPWM1_BASE);
	HRPWM_setMEPEdgeSelect(myEPWM1_BASE, HRPWM_CHANNEL_A, HRPWM_MEP_CTRL_FALLING_EDGE);
	HRPWM_setMEPControlMode(myEPWM1_BASE, HRPWM_CHANNEL_A, HRPWM_MEP_DUTY_PERIOD_CTRL);
	HRPWM_setCounterCompareShadowLoadEvent(myEPWM1_BASE, HRPWM_CHANNEL_A, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);


	/*--SFO ṹ0--*/
	SFO_Struct_deinit(&SFO_ParamsStruct);
	/*--SFO ṹ帳ֵloop_cntƼ4~5--*/
	SFO_Struct_init(&SFO_ParamsStruct,5);

}



void InitTimerModule(uint32_t period)
{
	/* Initialize CPUTimer with interrupt enable */
	CPUTimer_init(CPUTIMER1_BASE, period);
	Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
	Interrupt_enable(INT_TIMER1);
	Interrupt_SetPriority( INT_TIMER1,  1,  0);
}

void error()
{
	/**/
}

//	1msһ
__interrupt void TIMER1_IRQHandler(void)
{

	status = SFO(&SFO_ParamsStruct);
	//һУ׼
    if (status !=0)
    {
    	error();
    }

	//duty
	if(PWM1_duty < 0.8){
		PWM1_duty += temp_duty;}
	else{
		PWM1_duty = 0;}

	//duty CMPֺС֨分
	if(AUTO){
		HRPWM_Update_HrDuty_Auto(myEPWM1_BASE,PWM1_PRD+1,PWM1_duty,HRPWM_COUNTER_COMPARE_A);
		}
	else{
		HRPWM_Update_HrDuty_Manual(myEPWM1_BASE,PWM1_PRD+1,PWM1_duty,HRPWM_COUNTER_COMPARE_A);
	}
	CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
	CPUTimer_ClearInterruptStatus(CPUTIMER1_BASE);

}

//HRPWMautoconvʹô˺ȥCMPֺС
void HRPWM_Update_HrDuty_Auto(uint32_t base,uint32_t period,float32_t duty,HRPWM_CounterCompareModule cmpare)
{
	uint32_t cmp_set = 0;
	/*Сֿ*/
	//CMPHR = frac(duty*period) * 256 +0.5 СֵļԼֵ
	cmp_set =( (duty*period- (uint32_t)(duty*period)) *256) + 0.5;
	//ֵļԼֵ
	cmp_set += (uint32_t)(duty*period)<<8;

	/*Сһ
	 * 	cmp_set = duty*period*256;
	 * */

	if(cmpare){
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_B,cmp_set);
	}
	else{
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_A,cmp_set);
	}
}


//δHRPWMautoconvʹô˺ȥCMP߾Ȳ
void HRPWM_Update_HrDuty_Manual(uint32_t base,uint32_t period,float32_t duty,HRPWM_CounterCompareModule cmpare)
{
	uint32_t cmp_set = 0;

	//
	uint32_t duty_i = (uint32_t)(duty*period);
	//С
	float32_t duty_f = duty*period - duty_i;


	//CMPHR = frac(duty*period) * hrstep +0.5
	cmp_set =duty_f * SFO_ParamsStruct.HR_mstep + 0.5;
	if(cmpare){
		HRPWM_setCmpHRINT(base,cmp_set,SFO_ParamsStruct.HR_mstep,HRPWM_COUNTER_COMPARE_B);
		cmp_set += duty_i<<8;
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_B,cmp_set);
	}
	else{
		HRPWM_setCmpHRINT(base,cmp_set,SFO_ParamsStruct.HR_mstep,HRPWM_CHANNEL_A);
		cmp_set += duty_i<<8;
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_A,cmp_set);
	}
}




#ifdef __cplusplus

#endif

