/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    test.h
*   @brief   
*
*/

#ifndef _EEPROM_H_
#define _EEPROM_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "inc/hw_types.h"


typedef enum
{
    I2C_NEXT_CONDITION_NONE          = 0x01,
    I2C_NEXT_CONDITION_STOP          = 0x02,
    I2C_NEXT_CONDITION_RESTART       = 0x04,
} I2C_NEXT_CONDITION;


int32_t eeprom_DataAddrWrite(uint32_t base, uint32_t data_addr);

int32_t eeprom_DataCmdWrite(uint32_t base, uint8_t *data_cmd, uint32_t data_cmd_len);

int32_t eeprom_DataCmdRead(uint32_t base, uint8_t *data_cmd, uint32_t data_cmd_len);

int32_t eeprom_DataCmdReadReq(uint32_t base, uint8_t *data_cmd, uint32_t data_cmd_len);

int32_t eeprom_DataCmdReadReceive(uint32_t base, uint8_t *data_cmd, uint32_t data_cmd_len);

void eeprom_init(uint32_t addr_len);

#ifdef __cplusplus
}
#endif


#endif /* _EEPROM_H_ */
