/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


#ifndef __EEPROM_POLLING_REGISTER_H_
#define __EEPROM_POLLING_REGISTER_H_

#ifdef __cplusplus
extern "C"{
#endif

#define I2C_SUCCESS                 0x0000
#define I2C_NACK_ERROR				0x4000
#define I2C_BUS_BUSY_ERROR          0x1000
#define I2C_NO_FLAGS				0x2000

#define EEPROM_SLAVE_ADDRESS   0x50

#define EEPROM_PAGE_LEN   8
#define W_DATA_LEN   EEPROM_PAGE_LEN*16 ////Byte Length of a page

#define W_ADDR       0x00//EEPROM address length
#define EEPROM_DATA_ADDRESS_LEN   1

extern uint32_t g_i2c_base;

void i2c_err_irq_check(uint32_t irq_status);
void I2CX_INTR_IRQHandler(void);
void i2c_eeprom_test(void);
uint16_t verifyEEPROMRead(uint32_t i2c_base);
void I2C_GPIO_init(void);
void I2Cinit(uint32_t i2c_base);
bool I2cGetTxReady(uint32_t i2c_base);
bool I2cGetBusStatus(uint32_t i2c_base);
Uint16 WriteData(Uint16 *Wdata, Uint16 RomAddress, Uint16 number);
Uint16 ReadData(Uint16 *RamAddr, Uint16 RomAddress, Uint16 number);


#ifdef __cplusplus
}
#endif

#endif
