/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __I2C_TRANSFER_H_
#define __I2C_TRANSFER_H_

#ifdef __cplusplus
extern "C"{
#endif

#include "inc/hw_types.h"
#include "inc/hw_memmap.h"


#define TARGET_ADDRESS   0x4C

#if (GS32_PART_NUM != 0x35)

#define I2CA_GPIO_PIN_SDA 0U
#define I2CA_GPIO_PIN_SCL 1U

#define I2CA_GPIO_CFG_SDA	GPIO_0_I2CA_SDA
#define I2CA_GPIO_CFG_SCL	GPIO_1_I2CA_SCL

#define I2CB_GPIO_PIN_SDA 2U
#define I2CB_GPIO_PIN_SCL 3U

#define I2CB_GPIO_CFG_SDA	GPIO_2_I2CB_SDA
#define I2CB_GPIO_CFG_SCL	GPIO_3_I2CB_SCL

#else

#define I2CA_SDA_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO28 = (GPIO_28_I2CA_SDA & GPIO_MUX_MASK)
#define I2CA_SCL_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO29 = (GPIO_29_I2CA_SCL & GPIO_MUX_MASK)

#define I2CB_SDA_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO30 = (GPIO_30_I2CB_SDA & GPIO_MUX_MASK)
#define I2CB_SCL_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO31 = (GPIO_31_I2CB_SCL & GPIO_MUX_MASK)

#endif


extern uint16_t sData[2];
extern uint16_t rData[2];
extern uint16_t rDataPoint;
extern uint16_t index123;

void i2c_init(void);
void i2c_buffer_init(void);

#ifdef __cplusplus
}
#endif

#endif

