/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"
#include "software_simulation.h"

static void iic_delay(void)
{
	uint8_t i=0;
	for(;i<20;i++);
}

void i2c_init(void)
{
#if (GS32_PART_NUM != 0x35)
	GPIO_setPinConfig(SDA_PINMUX);
	GPIO_setPinConfig(SCL_PINMUX);

	GPIO_setDirectionMode(SDA_PIN,GPIO_DIR_MODE_OUT);
	GPIO_setDirectionMode(SCL_PIN,GPIO_DIR_MODE_OUT);

#else

	I2C_SDA_PIN_MUX;
	I2C_SCL_PIN_MUX;

	SDA_OUTPUT;
	SCL_OUTPUT;

#endif
}

static void i2c_start(void)
{
	SDA_H;
	SCL_H;
	IIC_WAIT;
	SDA_L;
	IIC_WAIT;
	SCL_L;
	IIC_WAIT;
}

static void i2c_ack(void)
{
	SDA_L;
	IIC_WAIT;
	SCL_H;
	IIC_WAIT;
	SCL_L;
	IIC_WAIT;
	SDA_H;
}

static uint8_t i2c_waitack(void)
{
	uint8_t tempRe;

	SDA_H;
	IIC_WAIT;
	SCL_H;
	IIC_WAIT;
	SDA_INPUT;
	tempRe = SDA_READ;
	SDA_OUTPUT;
	SCL_L;
	IIC_WAIT;
	return tempRe;
}

static void i2c_nack(void)
{
	SDA_L;
	SCL_H;
	IIC_WAIT;
	SDA_H;
}

static void i2c_stop(void)
{
	SDA_L;
	SCL_H;
	IIC_WAIT;
	SDA_H;
	IIC_WAIT;
}

static void i2c_sendbyte(uint8_t data)
{
	uint8_t i;


	for(i = 0;i<8;i++){
		if(data & 0x80){
			SDA_H;
		}else{
			SDA_L;
		}
		IIC_WAIT;
		SCL_H;
		IIC_WAIT;
		SCL_L;
		if(i == 7){
			SDA_H;
		}
		data <<= 1;
		IIC_WAIT;
	}
}

static uint8_t i2c_readbyte(void)
{
    uint8_t i;
    uint8_t	tempData = 0;
    uint8_t	tempRe = 0;

    SDA_INPUT;

    for(i=0;i<8;i++){
    	tempData <<= 1;
    	SCL_H;
    	IIC_WAIT;
    	tempRe = SDA_READ;
    	if(tempRe){
    		tempData++;
    	}
    	SCL_L;
    	IIC_WAIT;
    }

    SDA_OUTPUT;

    return tempData;
}

int i2c_read_one_byte(uint8_t addr,uint8_t reg,uint8_t* data)
{
    uint8_t tempRe = 0;
    uint8_t tempaddr_W = addr<<1;
    uint8_t tempaddr_R = tempaddr_W + 1;

    i2c_start();
    i2c_sendbyte(tempaddr_W);
    tempRe = i2c_waitack();
    if(tempRe){
        return 1;
    }
    i2c_sendbyte(reg);
    tempRe = i2c_waitack();
    if(tempRe){
        return 2;
    }
    i2c_start();
    i2c_sendbyte(tempaddr_R);
    tempRe = i2c_waitack();
    if(tempRe){
        return 3;
    }
    *data = i2c_readbyte();
    i2c_nack();
    i2c_stop();
    return 0;
}

int i2c_read_buffer(uint8_t addr,uint8_t reg,uint8_t *data,uint32_t len)
{

    uint8_t tempRe = 0;
    uint8_t cnt = 0;
    uint8_t tempaddr_W = addr<<1;
    uint8_t tempaddr_R = tempaddr_W + 1;

    i2c_start();
    i2c_sendbyte(tempaddr_W);
    tempRe = i2c_waitack();
    if(tempRe){
        return 1;
    }
    i2c_sendbyte(reg);
    tempRe = i2c_waitack();
    if(tempRe){
        return 2;
    }
    i2c_start();
    i2c_sendbyte(tempaddr_R);
    tempRe = i2c_waitack();
    if(tempRe){
        return 3;
    }
    for(cnt = 0;cnt<len;cnt++){
        data[cnt] = i2c_readbyte();
        if(cnt != (len-1)){
            i2c_ack();
        }else{
            i2c_nack();
        }
    }

    i2c_stop();
    return 0;
}

int i2c_write_one_byte(uint8_t addr,uint8_t reg,uint8_t data)
{
    uint8_t tempRe = 0;
    uint16_t tempaddr = addr<<1;

    i2c_start();
    i2c_sendbyte(tempaddr);
    tempRe = i2c_waitack();
    if(tempRe){
        return 1;
    }
    i2c_sendbyte(reg);
    tempRe = i2c_waitack();
    if(tempRe){
        return 2;
    }
    i2c_sendbyte(data);
    tempRe = i2c_waitack();
    if(tempRe){
        return 3;
    }
    i2c_stop();

    return 0;
}

int i2c_write_buffer(uint8_t addr,uint8_t reg, uint8_t *data,uint32_t len)
{
    uint8_t tempRe = 0;
    uint8_t cnt = 0;
    uint8_t tempaddr = addr<<1;

    i2c_start();
    i2c_sendbyte(tempaddr);
    tempRe = i2c_waitack();
    if(tempRe){
        return 1;
    }
    i2c_sendbyte(reg);
    tempRe = i2c_waitack();
    if(tempRe){
        return 2;
    }
    for(cnt = 0;cnt<len;cnt++){
        i2c_sendbyte(data[cnt]);
        tempRe = i2c_waitack();
        if(tempRe){
            return 3+cnt;
        }
    }
    i2c_stop();

    return 0;
}

