#include <stdint.h>
#include <string.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"

#define INPUT_XBAR_GPIO_FOR_XINT     	25
#define INPUT_XBAR_GPIO_FOR_XINT_CFG	GPIO_25_GPIO25

volatile uint32_t xintIrqCnt[16];

void CPU_XINT_IRQHandler(uint32_t id)
{
	xintIrqCnt[id] += 1;
}

void CPU_1XINT_IRQHandler(void)  {CPU_XINT_IRQHandler(0);}
void CPU_2XINT_IRQHandler(void)  {CPU_XINT_IRQHandler(1);}
void CPU_3XINT_IRQHandler(void)  {CPU_XINT_IRQHandler(2);}
void CPU_4XINT_IRQHandler(void)  {CPU_XINT_IRQHandler(3);}
void CPU_5XINT_IRQHandler(void)  {CPU_XINT_IRQHandler(4);}
void CPU_6XINT_IRQHandler(void)  {CPU_XINT_IRQHandler(5);}
void CPU_7XINT_IRQHandler(void)  {CPU_XINT_IRQHandler(6);}
void CPU_8XINT_IRQHandler(void)  {CPU_XINT_IRQHandler(7);}
void CPU_9XINT_IRQHandler(void)  {CPU_XINT_IRQHandler(8);}
void CPU_10XINT_IRQHandler(void) {CPU_XINT_IRQHandler(9);}
void CPU_11XINT_IRQHandler(void) {CPU_XINT_IRQHandler(10);}
void CPU_12XINT_IRQHandler(void) {CPU_XINT_IRQHandler(11);}
void CPU_13XINT_IRQHandler(void) {CPU_XINT_IRQHandler(12);}
void CPU_14XINT_IRQHandler(void) {CPU_XINT_IRQHandler(13);}
void CPU_15XINT_IRQHandler(void) {CPU_XINT_IRQHandler(14);}
void CPU_16XINT_IRQHandler(void) {CPU_XINT_IRQHandler(15);}

const void (*_xint_irq_handler[])(void) = {
    CPU_1XINT_IRQHandler,
    CPU_2XINT_IRQHandler,
    CPU_3XINT_IRQHandler,
    CPU_4XINT_IRQHandler,
    CPU_5XINT_IRQHandler,
    CPU_6XINT_IRQHandler,
    CPU_7XINT_IRQHandler,
    CPU_8XINT_IRQHandler,
    CPU_9XINT_IRQHandler,
    CPU_10XINT_IRQHandler,
    CPU_11XINT_IRQHandler,
    CPU_12XINT_IRQHandler,
    CPU_13XINT_IRQHandler,
    CPU_14XINT_IRQHandler,
    CPU_15XINT_IRQHandler,
    CPU_16XINT_IRQHandler,
};

static void XintInit(void)
{
    __disable_irq();

    GPIO_setPinConfig(INPUT_XBAR_GPIO_FOR_XINT_CFG);
    GPIO_setLoopBack(INPUT_XBAR_GPIO_FOR_XINT, 1);
    GPIO_enableWritePin(INPUT_XBAR_GPIO_FOR_XINT);
    GPIO_writePin(INPUT_XBAR_GPIO_FOR_XINT, 0);

    for (uint32_t i=0; i<16; i+=1) {
        uint32_t xbarInput = XBAR_INPUT1 + (XBAR_INPUT2 - XBAR_INPUT1)*i;
        XBAR_setInputPin(INPUTXBAR_BASE, xbarInput, INPUT_XBAR_GPIO_FOR_XINT);

        if (i == 0) {
            Interrupt_register(INT_XINT1, _xint_irq_handler[i]);
            ECLIC_SetTrigIRQ(INT_XINT1, ECLIC_POSTIVE_EDGE_TRIGGER);
            Interrupt_enable(INT_XINT1);
        } else if (i == 1) {
            Interrupt_register(INT_XINT2, _xint_irq_handler[i]);
            ECLIC_SetTrigIRQ(INT_XINT2, ECLIC_NEGTIVE_EDGE_TRIGGER);
            Interrupt_enable(INT_XINT2);
        } else {
            Interrupt_register(INT_XINT3-(i-2), _xint_irq_handler[i]);
            Interrupt_enable(INT_XINT3-(i-2));
        }
    }

    __enable_irq();
}

int32_t XintIrqTest(void)
{
    static int32_t start = 0;

    if (start == 0) {
        printf("---------- start Xint interrupt testing ---------\r\n");

        XintInit();
        start = 1;
    } else {
    	static uint32_t old = 0;

        if(old != GPIO_readPin(INPUT_XBAR_GPIO_FOR_XINT)) {
            old = GPIO_readPin(INPUT_XBAR_GPIO_FOR_XINT);

            printf("gpio %d: %d, xint1 rising irq: %d, xint2 falling irq: %d\r\n", INPUT_XBAR_GPIO_FOR_XINT, old, xintIrqCnt[0], xintIrqCnt[1]);
        }

        GPIO_togglePin(INPUT_XBAR_GPIO_FOR_XINT);
    }

    return 0;
}


















