/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __DMA_CONTROLLER_H_
#define __DMA_CONTROLLER_H_

#ifdef __cplusplus
extern "C"{
#endif

#include "inc/hw_types.h"
#include "inc/hw_memmap.h"
#include "lin_transfer.h"

#define LIN_PDCM_CONFIG		(0U)
#define FRAME_LENGTH        (8U)
#define TOTAL_MSG           (4)

#if(IS_GS32F00xx(0x12))

#if(LIN_BASE == LINA_BASE)

#define DMAMUX_LIN_TX DMAMUX_ReqId_lin1_tx
#define DMAMUX_LIN_RX DMAMUX_ReqId_lin1_rx

#elif (LIN_BASE == LINB_BASE)

#define DMAMUX_LIN_TX DMAMUX_ReqId_lin2_tx
#define DMAMUX_LIN_RX DMAMUX_ReqId_lin2_rx

#endif

#elif (IS_GS32F3xx(0x22))

#if(LIN_BASE == LINA_BASE)

#define DMAMUX_LIN_TX DMAMUX_ReqId_lin1_tx
#define DMAMUX_LIN_RX DMAMUX_ReqId_lin1_rx

#elif (LIN_BASE == LINB_BASE)

#define DMAMUX_LIN_TX DMAMUX_ReqId_lin2_tx
#define DMAMUX_LIN_RX DMAMUX_ReqId_lin2_rx

#endif

#endif

struct LINMR_Conf
{
    // NACT:
    // 00  PUBLISAH,    The LIN controller transmits the response.
    // 01  SUBSCRIBE,   The LIN controller receives the response.
    // 10  IGNORE,      The LIN controller does not transmit and does not
    //                          receive the response.
    uint8_t    nact:2;         //1:0

    //PARDIS: Parity Disable
    // 0: In Master node configuration, the Identifier Parity is computed and sent
    //    automatically. In Master node and Slave node configuration, the parity
    //    is checked automatically.
    // 1:  Whatever the node configuration is, the Identifier parity is not
    //    computed/sent and it is not checked.
    uint8_t    pardis:1;       //2

    // CHKDIS: Checksum Disable
    // 0: In Master node configuration, the checksum is computed and sent automatically.
    //    In Slave node configuration, the checksum is checked automatically.
    // 1: Whatever the node configuration is, the checksum is not computed/sent
    //    and it is not checked
    uint8_t    chkdis:1;      //3


    // CHKTYP: Checksum Type
    // 0: LIN 2.0 "Enhanced" Checksum
    // 1: LIN 1.3 "Classic" Checksum
    uint8_t    chktyp:1;      //4

    // DLM: Data Length Mode
    // 0: The response data length is defined by the field DLC of this register.
    // 1: The response data length is defined by the bits 5 and 6 of the Identifier
    //    (IDCHR in US_LINIR).
    uint8_t    dlm:1;         //5

    // FSDIS: Frame Slot Mode Disable
    // 0: The Frame Slot Mode is enabled.
    // 1: The Frame Slot Mode is disabled.
    uint8_t    fsdis:1;       //6

    // WKUPTYP: Wakeup Signal Type
    // 0: Setting the bit LINWKUP in the control register sends a LIN 2.0 wakeup
    //    signal.
    // 1: Setting the bit LINWKUP in the control register sends a LIN 1.3 wakeup
    //    signal.
    uint8_t     wkuptyp:1;     //7
};

union LIN_Conf_REG {
    uint8_t                all;
    struct LINMR_Conf      bit;
};

typedef struct
{
#if(LIN_PDCM_CONFIG)
    union LIN_Conf_REG mr;
    uint8_t dlc;
#endif
    uint8_t identifier;
#if(LIN_ACTION)
    uint8_t Data[FRAME_LENGTH];
#endif
} LIN_MasterMegsBuf;

#if(!LIN_ACTION)
typedef struct
{
    uint8_t Data[FRAME_LENGTH];
}LIN_MasterSubMegsBuf;
#endif

void dma_init(uint32_t linbase);

#ifdef __cplusplus
}
#endif

#endif
