/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __MCAN_SCHEDULED_H__
#define __MCAN_SCHEDULED_H__

#include "inc/hw_types.h"
#include "inc/hw_memmap.h"

#define CAN_BASE			CANA_BASE

#if (CAN_BASE == CANA_BASE)

#define CAN_TX_PIN			GPIO_5_CANA_RX
#define CAN_RX_PIN			GPIO_4_CANA_TX

#define CAN_IRQ_LINE0		INT_CANA0
#define CAN_IRQ_LINE1		INT_CANA1

#elif (CAN_BASE == CANB_BASE)

#define CAN_TX_PIN			GPIO_5_CANB_RX
#define CAN_RX_PIN			GPIO_6_CANB_TX

#define CAN_IRQ_LINE0		INT_CANB0
#define CAN_IRQ_LINE1		INT_CANB1

#endif

void mcan_init();
void scheduledsend();
void scheduledreception(void);

#endif
