#include "device.h"
#include "driverlib.h"
#include "load_img.h"
#include "log.h" //smp thread safe
#include "board_cfg.h"

#define MAX_SAMPLE  2048

uint16_t mySD1Filter1DataBuffer[MAX_SAMPLE + 20] = { [ 0 ... (MAX_SAMPLE + 20 - 1)] = 0x5a};
int DMAFinish = 0;

void DMA_CH0_IRQHandler()
{
    DMAFinish = 1;
#if IS_GS32F00xx(0x12)
    DMA_clearInterrupt(DMA1_CH1_BASE,DMA_INT_TFR);
#elif IS_GS32F3xx(0x22)
    XDMA_clearInterrupt(DMA1_CH1_BASE,XDMA_INT_TFR);
#elif IS_GS32F00xx(0x30)
    DMA_clearInterrupt(DMA_CH1_BASE,DMA_INT_TFR);
#endif
    __DSB();
}
int main()
{
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);
    log_set_level(LOG_INFO);
    log_info("print ok \r\n");

    GPIO_setPinConfig(GPIO_17_SD1_C1);
    GPIO_setPadConfig(17, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(17, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(GPIO_16_SD1_D1);
    GPIO_setPadConfig(16, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(16, GPIO_QUAL_ASYNC);
    
    SysCtl_configureType(1);
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_SDFM);

    // Comparator parameter
    Sdfm1Regs.SDCPARM1.bit.CS1_CS0 = 3;
    Sdfm1Regs.SDCPARM1.bit.COSR = 32 - 1;

    Sdfm1Regs.SDDFPARM1.all |= 128 - 1;
    // Sdfm1Regs.SDDFPARM1.bit.DOSR = 128 - 1;  unsupport store byte command
    Sdfm1Regs.SDDFPARM1.bit.SST = 3;
    Sdfm1Regs.SDDFPARM1.bit.FEN = 1;

    // Data parameter
    Sdfm1Regs.SDDPARM1.bit.DR = 0;
    Sdfm1Regs.SDDPARM1.bit.SH = 7;

    Sdfm1Regs.SDCTLPARM1.bit.MOD = SDFM_MODULATOR_CLK_EQUAL_DATA_RATE;
    Sdfm1Regs.SDCTLPARM1.bit.SDCLKSEL = 1;
    Sdfm1Regs.SDFLT1CMPH1.bit.HLT = 0x7fff;
    Sdfm1Regs.SDFLT1CMPL1.bit.LLT = 0;
    Sdfm1Regs.SDMFILEN.bit.MFE = 1;

#if IS_GS32F00xx(0x12)
    DMA_initController(DMA1_BASE);
    DMA_enableInterrupt(DMA1_BASE);
#elif IS_GS32F3xx(0x22)
    XDMA_initController(DMA1_BASE);
    XDMA_enableInterrupt(DMA1_BASE);
#elif IS_GS32F00xx(0x30)
    DMA_initController(DMA_BASE);
    DMA_enableInterrupt(DMA_BASE);
#endif
    Interrupt_register(INT_DMA1_CH1,DMA_CH0_IRQHandler);
    Interrupt_enable(INT_DMA1_CH1);

#if IS_GS32F00xx(0x12)
    DMA_ConfigParams dmaCfg = {0};
    dmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt1;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA1 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter1DataBuffer;
    dmaCfg.blockTS = MAX_SAMPLE;
    dmaCfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.reloadSrc = false;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_2;

#elif IS_GS32F3xx(0x22)
    XDMA_ConfigParams dmaCfg = {0};
    dmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt1;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA1 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter1DataBuffer;
    dmaCfg.blockTS = MAX_SAMPLE;
    dmaCfg.ttfc    = XDMA_TT_FC_2_P2M_DMAC;
    dmaCfg.srcBtl  = XDMA_BTL_1;
    dmaCfg.reloadSrc = false;
    dmaCfg.destBtl = XDMA_BTL_1;
    dmaCfg.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
    dmaCfg.destAddrDirect = XDMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_2;
    dmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_2;
#elif IS_GS32F00xx(0x30)
    DMA_ConfigParams dmaCfg = {0};
    dmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt1;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA1 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter1DataBuffer;
    dmaCfg.blockTS = MAX_SAMPLE;
    dmaCfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.reloadSrc = false;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_2;
#endif

#if IS_GS32F00xx(0x12)
    DMA_configChannel(DMA1_CH1_BASE, &dmaCfg);
    DMA_clearInterrupt(DMA1_CH1_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA1_CH1_BASE, DMA_INT_TFR);
    DMA_startChannel(DMA1_CH1_BASE);
#elif IS_GS32F3xx(0x22)
    XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg);
    XDMA_clearInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR);
    XDMA_unMaskInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR);
    XDMA_startChannel(DMA1_CH1_BASE);
#elif IS_GS32F00xx(0x30)
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);
    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
    DMA_startChannel(DMA_CH1_BASE);
#endif

    __enable_irq();

    while (1)
    {
        if (DMAFinish == 1)
        {
#if IS_GS32F00xx(0x12)
            DMA_stopChannel(DMA1_CH1_BASE);
#elif IS_GS32F3xx(0x22)
            XDMA_stopChannel(DMA1_CH1_BASE);
#elif IS_GS32F00xx(0x30)
            DMA_stopChannel(DMA_CH1_BASE);
#endif
        }
        
    }
    
    return 0;
}

