//###########################################################################
//
// FILE:   sdfm_ex3_filter_sync_dmaread.c
//
// TITLE:  SDFM Filter Sync DMA Example.
//
//! \addtogroup driver_example_list
//! <h1> SDFM Filter Sync DMA </h1>
//!
//! In this example, SDFM filter data is read by DMA. The
//! SDFM configuration is shown below:
//!  - SDFM1 used in this example. For using SDFM2, few modifications
//!    would be needed in the example.
//!  - MODE0 Input control mode selected
//!  - Comparator settings
//!      - Sinc3 filter selected
//!      - OSR = 32
//!      - hlt = 0x7FFF (Higher threshold setting)
//!      - llt  = 0x0000(Lower threshold setting)
//!  - Data filter settings
//!      - All the 4 filter modules enabled
//!      - Sinc3 filter selected
//!      - OSR = 256
//!      - All the 4 filters are synchronized by using MFE
//!       (Master Filter enable bit)
//!      - Filter output represented in 16 bit format
//!      - In order to convert 25 bit Data filter
//!        into 16 bit format user needs to right shift by 10 bits for
//!        Sinc3 filter with OSR = 256
//!  - Interrupt module settings for SDFM filter
//!      - All the 4 higher threshold comparator interrupts disabled
//!      - All the 4 lower threshold comparator interrupts disabled
//!      - All the 4 modulator failure interrupts disabled
//!      - All the 4 filter will generate interrupt when a new filter
//!        data is available
//!
//! \b External \b Connections \n
//		SD1-C1 -> GPIO17
//		SD1-D1 -> GPIO48 Connect to Sigma-Delta streams
//		SD1-C2 -> GPIO19
//		SD1-D2 -> GPIO18 Connect to Sigma-Delta streams
//		SD1-C3 -> GPIO53
//		SD1-D3 -> GPIO52 Connect to Sigma-Delta streams
//		SD1-C4 -> GPIO55
//		SD1-D4 -> GPIO22 Connect to Sigma-Delta streams
//!
//! \b Watch \b Variables \n
//! -  \b filter1Result - Output of filter 1
//! -  \b filter2Result - Output of filter 2
//! -  \b filter3Result - Output of filter 3
//! -  \b filter4Result - Output of filter 4
//!
//
//###########################################################################
/*
 *   Copyright (c) Gejian Semiconductors 2024
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
//###########################################################################

#include <time.h>
#include <stdlib.h>
#include "sdfm_ex3_filter_sync_dmaread_board.h"
#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"

#define MAX_SAMPLES               1024

/**
 * SD1F4 ok
 * */
void DMA_CH0_IRQHandler();
void DMA_CH1_IRQHandler();
void DMA_CH2_IRQHandler();
void DMA_CH3_IRQHandler();

int main(void)
{


    Device_init();
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_SDFM);
    UartPrint_init(LOG_SCI_BASE, 115200);
    printf("print ok\r\n");

    Board_init();

#if IS_GS32F00xx(0x12)
    Interrupt_register(INT_DMA1_CH1, &DMA_CH0_IRQHandler);
    Interrupt_register(INT_DMA1_CH2, &DMA_CH1_IRQHandler);
    Interrupt_register(INT_DMA1_CH3, &DMA_CH2_IRQHandler);
    Interrupt_register(INT_DMA1_CH4, &DMA_CH3_IRQHandler);
    Interrupt_enable(INT_DMA1_CH1);
    Interrupt_enable(INT_DMA1_CH2);
    Interrupt_enable(INT_DMA1_CH3);
    Interrupt_enable(INT_DMA1_CH4);
#elif IS_GS32F3xx(0x22)
    Interrupt_register(INT_DMA1_CH1, &DMA_CH0_IRQHandler);
    Interrupt_register(INT_DMA1_CH2, &DMA_CH1_IRQHandler);
    Interrupt_register(INT_DMA1_CH3, &DMA_CH2_IRQHandler);
    Interrupt_register(INT_DMA1_CH4, &DMA_CH3_IRQHandler);
    Interrupt_enable(INT_DMA1_CH1);
    Interrupt_enable(INT_DMA1_CH2);
    Interrupt_enable(INT_DMA1_CH3);
    Interrupt_enable(INT_DMA1_CH4);
#elif IS_GS32F00xx(0x30)
    Interrupt_register(INT_DMA1_CH1, &DMA_CH0_IRQHandler);
    Interrupt_register(INT_DMA1_CH2, &DMA_CH1_IRQHandler);
    Interrupt_register(INT_DMA1_CH3, &DMA_CH2_IRQHandler);
    Interrupt_register(INT_DMA1_CH4, &DMA_CH3_IRQHandler);
    Interrupt_enable(INT_DMA1_CH1);
    Interrupt_enable(INT_DMA1_CH2);
    Interrupt_enable(INT_DMA1_CH3);
    Interrupt_enable(INT_DMA1_CH4);
#endif


    //
    // Enable Global Interrupt (INTM)
    //
    EINT;


    while (1) {

    }

    return 0;
}

void DMA_CH0_IRQHandler()
{
#if IS_GS32F00xx(0x12)
    DMA_clearInterrupt(DMA1_CH1_BASE,DMA_INT_TFR);
    __DSB();
#elif IS_GS32F3xx(0x22)
    XDMA_clearInterrupt(DMA1_CH1_BASE,XDMA_INT_TFR);
    __DSB();
#elif IS_GS32F00xx(0x30)
    DMA_clearInterrupt(DMA_CH1_BASE,DMA_INT_TFR);
    __DSB();
#endif
}


void DMA_CH1_IRQHandler()
{
#if IS_GS32F00xx(0x12)
    DMA_clearInterrupt(DMA1_CH2_BASE,DMA_INT_TFR);
    __DSB();
#elif IS_GS32F3xx(0x22)
    XDMA_clearInterrupt(DMA1_CH2_BASE,XDMA_INT_TFR);
    __DSB();
#elif IS_GS32F00xx(0x30)
    DMA_clearInterrupt(DMA_CH2_BASE,DMA_INT_TFR);
    __DSB();
#endif
}

void DMA_CH2_IRQHandler()
{
#if IS_GS32F00xx(0x12)
    DMA_clearInterrupt(DMA1_CH3_BASE,DMA_INT_TFR);
    __DSB();
#elif IS_GS32F3xx(0x22)
    XDMA_clearInterrupt(DMA1_CH3_BASE,XDMA_INT_TFR);
    __DSB();
#elif IS_GS32F00xx(0x30)
    DMA_clearInterrupt(DMA_CH3_BASE,DMA_INT_TFR);
    __DSB();
#endif
}

void DMA_CH3_IRQHandler()
{
#if IS_GS32F00xx(0x12)
    DMA_clearInterrupt(DMA1_CH4_BASE,DMA_INT_TFR);
    __DSB();
#elif IS_GS32F3xx(0x22)
    XDMA_clearInterrupt(DMA1_CH4_BASE,XDMA_INT_TFR);
    __DSB();
#elif IS_GS32F00xx(0x30)
    DMA_clearInterrupt(DMA_CH4_BASE,DMA_INT_TFR);
    __DSB();
#endif
}


