
#include "sdfm_ex5_type1_filter_fifo_cpuread_board.h"
#include "sdfm.h"
// SDFM1 SD1_C1 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C1 17
#define mySDFM1_SDFM1C1_GPIO 17
#define mySDFM1_SDFM1C1_PIN_CONFIG GPIO_17_SD1_C1
//
// SDFM1 SD1_D1 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D1 16
#define mySDFM1_SDFM1D1_GPIO 16
#define mySDFM1_SDFM1D1_PIN_CONFIG GPIO_16_SD1_D1


// SDFM1 SD1_C2 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C2 19
#define mySDFM1_SDFM1C2_GPIO 19
#define mySDFM1_SDFM1C2_PIN_CONFIG GPIO_19_SD1_C2
//
// SDFM1 SD1_D2 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D2 18
#define mySDFM1_SDFM1D2_GPIO 18
#define mySDFM1_SDFM1D2_PIN_CONFIG GPIO_18_SD1_D2


//
// SDFM1 SD1_C3 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C3 53
#define mySDFM1_SDFM1C3_GPIO 53
#define mySDFM1_SDFM1C3_PIN_CONFIG GPIO_53_SD1_C3
//
// SDFM1 SD1_D3 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D3 52
#define mySDFM1_SDFM1D3_GPIO 52
#define mySDFM1_SDFM1D3_PIN_CONFIG GPIO_52_SD1_D3

//
// SDFM1 SD1_C4 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C4 55
#define mySDFM1_SDFM1C4_GPIO 55
#define mySDFM1_SDFM1C4_PIN_CONFIG GPIO_55_SD1_C4

//
// SDFM1 SD1_D4 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D4 22
#define mySDFM1_SDFM1D4_GPIO 22
#define mySDFM1_SDFM1D4_PIN_CONFIG GPIO_22_SD1_D4

//
// Defines
//
#define MAX_SAMPLES               1024
#define FIFO_INT_NUM              16U
#define SDFM_FILTER_ENABLE 0x2U

//
// Macro to enable FIFO mode. Make it zero to disable
// FIFO mode.
//
#define ENABLE_FIFO               1

//
// Macro for pin-mux options
//
#define SDFM_PIN_MUX_OPTION1      1
#define SDFM_PIN_MUX_OPTION2      2

void Board_init(void){
	PinMux_init();
	sdfm_init();
}
void PinMux_init()
{

	// SDFM1 Pin Mux
	//SDFM1 SD1_C1 _GP17
	GPIO_setPinConfig(mySDFM1_SDFM1C1_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C1_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C1_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C1_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D1 _GP16
	GPIO_setPinConfig(mySDFM1_SDFM1D1_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D1_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D1_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D1_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_C2 _GP19
	GPIO_setPinConfig(mySDFM1_SDFM1C2_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C2_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C2_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C2_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D2 _GP18
	GPIO_setPinConfig(mySDFM1_SDFM1D2_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D2_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D2_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D2_GPIO, GPIO_QUAL_ASYNC);


	//SDFM1 SD1_C3 _GP53
	GPIO_setPinConfig(mySDFM1_SDFM1C3_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C3_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C3_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C3_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D3 _GP52
	GPIO_setPinConfig(mySDFM1_SDFM1D3_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D3_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D3_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D3_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_C4 _GP55
	GPIO_setPinConfig(mySDFM1_SDFM1C4_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C4_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C4_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C4_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D4 _GP22
	GPIO_setPinConfig(mySDFM1_SDFM1D4_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D4_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D4_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D4_GPIO, GPIO_QUAL_ASYNC);


}

void sdfm_init(void){

    uint16_t  hlt, llt;


    //
    // Configure SDFM type to 0 and see if data ack generated SDINT.
    //
	SysCtl_configureType(1);


    //
    // Input Control Unit
    //
    // Configure Input Control Unit: Modulator Clock rate = Modulator data rate
    //
    Sdfm1Regs.SDCTLPARM1.bit.MOD = SDFM_MODULATOR_CLK_EQUAL_DATA_RATE;

    // Configure Data Filter Unit - filter type, OSR value and
    // enable / disable data filter
    //
    // Data filter parameter
    Sdfm1Regs.SDDFPARM1.all |= 256 - 1;
//    Sdfm1Regs.SDDFPARM1.bit.DOSR = 128 - 1;  unsupport store byte command
    Sdfm1Regs.SDDFPARM1.bit.SST = 3;
    Sdfm1Regs.SDDFPARM1.bit.FEN = 1;
    Sdfm1Regs.SDDFPARM1.bit.AE = 1;
    // Data parameter
    Sdfm1Regs.SDDPARM1.bit.DR = 0;
    Sdfm1Regs.SDDPARM1.bit.SH = 10;

#if (ENABLE_FIFO)
        //
        // Set data ready interrupt source as fifo interrupt
        //
//        SDFM_setDataReadyInterruptSource(SDFM1_BASE, SDFM_FILTER_1,
//                                         SDFM_DATA_READY_SOURCE_FIFO);
        Sdfm1Regs.SDFIFOCTL1.bit.DRINTSEL = 1;

        //
        // Enable FIFO and set the FIFO interrupt level
        //
//        SDFM_enableFIFOBuffer(SDFM1_BASE, SDFM_FILTER_1);
        Sdfm1Regs.SDFIFOCTL1.bit.FFEN = 1;

//        SDFM_setFIFOInterruptLevel(SDFM1_BASE, SDFM_FILTER_1, FIFO_INT_NUM);
        Sdfm1Regs.SDFIFOCTL1.bit.SDFFIL = FIFO_INT_NUM;

//        SDFM_enableInterrupt(SDFM1_BASE, SDFM_FILTER_1,
//                         (SDFM_FIFO_INTERRUPT | SDFM_FIFO_OVERFLOW_INTERRUPT));
        Sdfm1Regs.SDFIFOCTL1.bit.FFIEN = 1;
        Sdfm1Regs.SDFIFOCTL1.bit.OVFIEN = 1;
#else
        //
        // Set data ready interrupt source as fifo interrupt
        //
//        SDFM_setDataReadyInterruptSource(SDFM1_BASE, SDFM_FILTER_1,
//                                         SDFM_DATA_READY_SOURCE_DIRECT);

        Sdfm1Regs.SDFIFOCTL1.bit.DRINTSEL = 0;

//        SDFM_enableInterrupt(SDFM1_BASE, SDFM_FILTER_1,
//                             SDFM_DATA_FILTER_ACKNOWLEDGE_INTERRUPT);
        Sdfm1Regs.SDDFPARM4.bit.AE = 1;
#endif


	//
	// Enable Master filter bit: Unless this bit is set none of the filter
	// modules can be enabled. All the filter modules are synchronized when
	// master filter bit is enabled after individual filter modules are enabled.
	//
	Sdfm1Regs.SDMFILEN.bit.MFE = 1;

    Sdfm1Regs.SDDFPARM1.bit.SDSYNCEN = 0;

	//
	// Enable modulator failure interrupt, disable threshold interrupts
	//
    Sdfm1Regs.SDCPARM1.bit.MFIE = 0;

    Sdfm1Regs.SDCPARM1.bit.EN_CEVT1 = 0;
    Sdfm1Regs.SDCPARM1.bit.EN_CEVT2 = 0;

	//
	// Enable master interrupt so that any of the filter interrupts can trigger
	// by SDFM interrupt to CPU
	//
    Sdfm1Regs.SDCTL.bit.MIE = 1;

//    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_1,SDFM_MODULATOR_FAILURE_INTERRUPT);
//    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_2,SDFM_MODULATOR_FAILURE_INTERRUPT);
//    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_3,SDFM_MODULATOR_FAILURE_INTERRUPT);
//    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_4,SDFM_MODULATOR_FAILURE_INTERRUPT);

}








