/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include <spi_ex01_board.h>


//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void Board_init()
{
	PinMux_init();
	SPI_init();
}

void PinMux_init(void)
{
#if IS_GS32F00xx(0x12)
	// SPIA Pin Mux
	//SPIA_STE_GP0
	GPIO_setPinConfig(mySPI0_SPISTE_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISTE_GPIO, GPIO_PIN_TYPE_STD|GPIO_PIN_TYPE_PULLUP);
	GPIO_setQualificationMode(mySPI0_SPISTE_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_CLK_GP12
	GPIO_setPinConfig(mySPI0_SPICLK_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPICLK_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPICLK_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_SIMO_GP11
	GPIO_setPinConfig(mySPI0_SPISIMO_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISIMO_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPISIMO_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_SOMI_GP1
	GPIO_setPinConfig(mySPI0_SPISOMI_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISOMI_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPISOMI_GPIO, GPIO_QUAL_ASYNC);

#elif IS_GS32F3xx(0x22)
	// SPIA Pin Mux
	//SPIA_STE_GP19
	GPIO_setPinConfig(mySPI0_SPISTE_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISTE_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPISTE_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_CLK_GP18
	GPIO_setPinConfig(mySPI0_SPICLK_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPICLK_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPICLK_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_SIMO_GP16
	GPIO_setPinConfig(mySPI0_SPISIMO_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISIMO_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPISIMO_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_SOMI_GP17
	GPIO_setPinConfig(mySPI0_SPISOMI_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISOMI_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPISOMI_GPIO, GPIO_QUAL_ASYNC);

#endif
}

void SPI_init(void)
{
	mySPI0_init();
}
void mySPI0_init()
{
	uint32_t ctrlr0 = 0;
    /*
     * Disable the SSI module before initialization
     * == SPI_disableModule(mySPI_BASE);
     */
	SpiaRegs.SSIENR.bit.SSI_EN = 0;

	/*
	 * Initialize SSI
	 * == 	SPI_setConfig(mySPI_BASE,DEVICE_APBCLK_FREQ,SPI_PROT_POL0PHA0,\
						SPI_MODE_CONTROLLER,mySPI_BITRATE,mySPI_DATAWIDTH);
	 */

	/*
	 * @brief SPI master/slave mode selection
	 * @note This operation must precede all other operations
	 */
	ApbCommParaRegs.SPI_MASTER_MODE.bit.SPIA_MASTER_MODE = 1;

	SpiaRegs.CTRLR0.bit.SCPOL =
			(SPI_PROT_POL0PHA0&SPI_CTRLR0_SCPOL_M)>>SPI_CTRLR0_SCPOL_S;
	SpiaRegs.CTRLR0.bit.SCPH =
			(SPI_PROT_POL0PHA0&SPI_CTRLR0_SCPH_M)>>SPI_CTRLR0_SCPH_S;
	SpiaRegs.CTRLR0.bit.TMOD =
			(SPI_MODE_CONTROLLER&SPI_CTRLR0_TMOD_M)>>SPI_CTRLR0_TMOD_S;

	SpiaRegs.CTRLR0.bit.DFS_32 = (mySPI_DATAWIDTH - 1);

	SpiaRegs.CTRLR0.bit.SSTE = 0;

	/*
	ctrlr0 = SPI_PROT_POL0PHA0 | (SPI_MODE_CONTROLLER & SPI_MODE_CONTROLLER);
	ctrlr0 |=  ((uint32_t)(mySPI_DATAWIDTH - 1) << SPI_CTRLR0_DFS_32_S);
	SpiaRegs.CTRLR0.all = ctrlr0;
	*/

	SpiaRegs.BAUDR.bit.SCKDV = ((DEVICE_APBCLK_FREQ / mySPI_BITRATE) &\
								(~0x00000001U));
	SpiaRegs.SER.bit.SER = 1;



	/*
	 * Disable all interrupt
	 * == SPI_disableAllInterrupt(mySPI_BASE);
	 *
	 */
	SpiaRegs.IMR.all = 0;


	/*
	 * Open loop
	 * == SPI_enableLoopback(mySPI_BASE);
	 */
	SpiaRegs.CTRLR0.bit.SRL = 1;

    /*
     * Enable the SSI module before initialization
     * ==	SPI_enableModule(mySPI_BASE);
     */
	SpiaRegs.SSIENR.bit.SSI_EN = 1;
}


#ifdef __cplusplus
}
#endif

