/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    spi_ex01_board.h
*   @brief
*   @details
*
*/

#ifndef SPI_EX01_BOARD_H_
#define SPI_EX01_BOARD_H_

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * Include Files
 */
#include "device.h"
#include "driverlib.h"
#include "board_cfg.h"

/*
 * PinMux Configuration
 */

#if IS_GS32F00xx(0x12)
/*
 * SPIA -> mySPI0 Pinmux
 */

 /* SPIA_SIMO - GPIO Settings */
#define GPIO_PIN_SPIA_SIMO 2
#define mySPI0_SPISIMO_GPIO 2
#define mySPI0_SPISIMO_PIN_CONFIG GPIO_2_SPIA_SIMO

/* SPIA_SOMI - GPIO Settings */
#define GPIO_PIN_SPIA_SOMI 1
#define mySPI0_SPISOMI_GPIO 1
#define mySPI0_SPISOMI_PIN_CONFIG GPIO_1_SPIA_SOMI

/* SPIA_CLK - GPIO Settings */
#define GPIO_PIN_SPIA_CLK 3
#define mySPI0_SPICLK_GPIO 3
#define mySPI0_SPICLK_PIN_CONFIG GPIO_3_SPIA_CLK

/* SPIA_STE - GPIO Settings */
#define GPIO_PIN_SPIA_STE 0
#define mySPI0_SPISTE_GPIO 0
#define mySPI0_SPISTE_PIN_CONFIG GPIO_0_SPIA_STE

#elif IS_GS32F3xx(0x22)
/*
 * SPIA -> mySPI0 Pinmux
 */

 /* SPIA_SIMO - GPIO Settings */
#define GPIO_PIN_SPIA_SIMO 16
#define mySPI0_SPISIMO_GPIO 16
#define mySPI0_SPISIMO_PIN_CONFIG GPIO_16_SPISIMOA

/* SPIA_SOMI - GPIO Settings */
#define GPIO_PIN_SPIA_SOMI 17
#define mySPI0_SPISOMI_GPIO 17
#define mySPI0_SPISOMI_PIN_CONFIG GPIO_17_SPISOMIA

/* SPIA_CLK - GPIO Settings */
#define GPIO_PIN_SPIA_CLK 18
#define mySPI0_SPICLK_GPIO 18
#define mySPI0_SPICLK_PIN_CONFIG GPIO_18_SPICLKA

/* SPIA_STE - GPIO Settings */
#define GPIO_PIN_SPIA_STE 19
#define mySPI0_SPISTE_GPIO 19
#define mySPI0_SPISTE_PIN_CONFIG GPIO_19_SPISTEA

#endif

/*
 * SPI Configurations
 */
#define mySPI_BASE SPIA_BASE
#define mySPI_BITRATE 1000000
#define mySPI_DATAWIDTH 16
void mySPI0_init();

/*
 * Board Configurations
 */
void	Board_init();
void	SPI_init();
void	PinMux_init();

#ifdef __cplusplus
}
#endif

#endif /* SPI_EX01_BOARD_H_ */
