/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.h
*   @brief
*   @details
*
*/

#ifndef SPI_EX03_BOARD_H_
#define SPI_EX03_BOARD_H_

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "driverlib.h"
#include "board_cfg.h"

/* ========================================================================== */
/*                           PinMux Configuration                             */
/* ========================================================================== */
#if IS_GS32F00xx(0x12)
//
// SPIA -> SPIA_peripheral Pinmux
//

//
// SPIA_SIMO - GPIO Settings
//
#define GPIO_PIN_SPIA_SIMO 2
#define SPIA_peripheral_SPISIMO_GPIO 2
#define SPIA_peripheral_SPISIMO_PIN_CONFIG GPIO_2_SPIA_SIMO
//
// SPIA_SOMI - GPIO Settings
//
#define GPIO_PIN_SPIA_SOMI 1
#define SPIA_peripheral_SPISOMI_GPIO 1
#define SPIA_peripheral_SPISOMI_PIN_CONFIG GPIO_1_SPIA_SOMI
//
// SPIA_CLK - GPIO Settings
//
#define GPIO_PIN_SPIA_CLK 3
#define SPIA_peripheral_SPICLK_GPIO 3
#define SPIA_peripheral_SPICLK_PIN_CONFIG GPIO_3_SPIA_CLK
//
// SPIA_STE - GPIO Settings
//
#define GPIO_PIN_SPIA_STE 0
#define SPIA_peripheral_SPISTE_GPIO 0
#define SPIA_peripheral_SPISTE_PIN_CONFIG GPIO_0_SPIA_STE

//
// SPIB -> SPIB_controller Pinmux
//
//
// SPIB_SIMO - GPIO Settings
//
#define GPIO_PIN_SPIB_SIMO 7
#define SPIB_controller_SPISIMO_GPIO 7
#define SPIB_controller_SPISIMO_PIN_CONFIG GPIO_7_SPIB_SIMO
//
// SPIB_SOMI - GPIO Settings
//
#define GPIO_PIN_SPIB_SOMI 6
#define SPIB_controller_SPISOMI_GPIO 6
#define SPIB_controller_SPISOMI_PIN_CONFIG GPIO_6_SPIB_SOMI
//
// SPIB_CLK - GPIO Settings
//
#define GPIO_PIN_SPIB_CLK 14
#define SPIB_controller_SPICLK_GPIO 14
#define SPIB_controller_SPICLK_PIN_CONFIG GPIO_14_SPIB_CLK
//
// SPIB_STE - GPIO Settings
//
#define GPIO_PIN_SPIB_STE 15
#define SPIB_controller_SPISTE_GPIO 15
#define SPIB_controller_SPISTE_PIN_CONFIG GPIO_15_SPIB_STE

#elif IS_GS32F3xx(0x22)
//
// SPIA -> SPIA_peripheral Pinmux
//
//
// SPIA_SIMO - GPIO Settings
//
#define GPIO_PIN_SPIA_SIMO 16
#define SPIA_peripheral_SPISIMO_GPIO 16
#define SPIA_peripheral_SPISIMO_PIN_CONFIG GPIO_16_SPIA_PICO
//
// SPIA_SOMI - GPIO Settings
//
#define GPIO_PIN_SPIA_SOMI 17
#define SPIA_peripheral_SPISOMI_GPIO 17
#define SPIA_peripheral_SPISOMI_PIN_CONFIG GPIO_17_SPIA_POCI
//
// SPIA_CLK - GPIO Settings
//
#define GPIO_PIN_SPIA_CLK 18
#define SPIA_peripheral_SPICLK_GPIO 18
#define SPIA_peripheral_SPICLK_PIN_CONFIG GPIO_18_SPIA_CLK
//
// SPIA_STE - GPIO Settings
//
#define GPIO_PIN_SPIA_STE 19
#define SPIA_peripheral_SPISTE_GPIO 19
#define SPIA_peripheral_SPISTE_PIN_CONFIG GPIO_19_SPIA_PTE

//
// SPIB -> SPIB_controller Pinmux
//
//
// SPIB_SIMO - GPIO Settings
//
#define GPIO_PIN_SPIB_SIMO 24
#define SPIB_controller_SPISIMO_GPIO 24
#define SPIB_controller_SPISIMO_PIN_CONFIG GPIO_24_SPIB_PICO
//
// SPIB_SOMI - GPIO Settings
//
#define GPIO_PIN_SPIB_SOMI 25
#define SPIB_controller_SPISOMI_GPIO 25
#define SPIB_controller_SPISOMI_PIN_CONFIG GPIO_25_SPIB_POCI
//
// SPIB_CLK - GPIO Settings
//
#define GPIO_PIN_SPIB_CLK 22
#define SPIB_controller_SPICLK_GPIO 22
#define SPIB_controller_SPICLK_PIN_CONFIG GPIO_22_SPIB_CLK
//
// SPIB_STE - GPIO Settings
//
#define GPIO_PIN_SPIB_STE 23
#define SPIB_controller_SPISTE_GPIO 23
#define SPIB_controller_SPISTE_PIN_CONFIG GPIO_23_SPIB_PTE
#endif

/* ========================================================================== */
/*                         SPI Configurations                                 */
/* ========================================================================== */
#define SPIA_peripheral_BASE SPIA_BASE
#define SPIA_peripheral_BITRATE 500000
#define SPIA_peripheral_DATAWIDTH 16
void SPIA_peripheral_init();
#define SPIB_controller_BASE SPIB_BASE
#define SPIB_controller_BITRATE 500000
#define SPIB_controller_DATAWIDTH 16
void SPIB_controller_init();

/* ========================================================================== */
/*                            Board Configurations                            */
/* ========================================================================== */
void	Board_init();
void	SPIX_init();
void	PinMux_init();

#ifdef __cplusplus
}
#endif

#endif /* SPI_EX03_BOARD_H_ */
