/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include <spi_ex04_board.h>

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void Board_init()
{
	PinMux_init();
	SPIX_init();
	INTERRUPT_init();
}

void PinMux_init(void)
{
	// SPIA_peripheral Pinmux
	//SPIA_SIMO
	GPIO_setPinConfig(SPIA_peripheral_SPISIMO_PIN_CONFIG);
	GPIO_setPadConfig(SPIA_peripheral_SPISIMO_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(SPIA_peripheral_SPISIMO_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_SOMI
	GPIO_setPinConfig(SPIA_peripheral_SPISOMI_PIN_CONFIG);
	GPIO_setPadConfig(SPIA_peripheral_SPISOMI_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(SPIA_peripheral_SPISOMI_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_CLK
	GPIO_setPinConfig(SPIA_peripheral_SPICLK_PIN_CONFIG);
	GPIO_setPadConfig(SPIA_peripheral_SPICLK_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(SPIA_peripheral_SPICLK_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_STE
	GPIO_setPinConfig(SPIA_peripheral_SPISTE_PIN_CONFIG);
	GPIO_setPadConfig(SPIA_peripheral_SPISTE_GPIO, GPIO_PIN_TYPE_STD|GPIO_PIN_TYPE_PULLUP);
	GPIO_setQualificationMode(SPIA_peripheral_SPISTE_GPIO, GPIO_QUAL_ASYNC);

	// SPIB_controller Pinmuxs
	//SPIB_SIMO
	GPIO_setPinConfig(SPIB_controller_SPISIMO_PIN_CONFIG);
	GPIO_setPadConfig(SPIB_controller_SPISIMO_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(SPIB_controller_SPISIMO_GPIO, GPIO_QUAL_ASYNC);

	//SPIB_SOMI
	GPIO_setPinConfig(SPIB_controller_SPISOMI_PIN_CONFIG);
	GPIO_setPadConfig(SPIB_controller_SPISOMI_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(SPIB_controller_SPISOMI_GPIO, GPIO_QUAL_ASYNC);

	//SPIB_CLK
	GPIO_setPinConfig(SPIB_controller_SPICLK_PIN_CONFIG);
	GPIO_setPadConfig(SPIB_controller_SPICLK_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(SPIB_controller_SPICLK_GPIO, GPIO_QUAL_ASYNC);

	//SPIB_STE
	GPIO_setPinConfig(SPIB_controller_SPISTE_PIN_CONFIG);
	GPIO_setPadConfig(SPIB_controller_SPISTE_GPIO, GPIO_PIN_TYPE_STD|GPIO_PIN_TYPE_PULLUP);
	GPIO_setQualificationMode(SPIB_controller_SPISTE_GPIO, GPIO_QUAL_ASYNC);
}

void INTERRUPT_init(void)
{
	Interrupt_register(INT_SPIA,spiARxFIFOISR);
	Interrupt_enable(INT_SPIA);
	Interrupt_register(INT_SPIB,spiBTxFIFOISR);
	Interrupt_enable(INT_SPIB);
}

void SPIX_init(void)
{
	SPIA_peripheral_init();
	SPIB_controller_init();
}
void SPIA_peripheral_init(void)
{
    // Disable the SSI module before initialization
	SPI_disableModule(SPIA_peripheral_BASE);

	// Initialize SSI
	SPI_setConfig(SPIA_peripheral_BASE,DEVICE_APBCLK_FREQ,SPI_PROT_POL0PHA0,\
			SPI_MODE_PERIPHERAL,SPIA_peripheral_BITRATE,SPIA_peripheral_DATAWIDTH);

    // Sets the FIFO level at which interrupts are generated.
    SPI_setFIFOInterruptLevel(SPIA_peripheral_BASE, SPI_FIFO_TX2, SPI_FIFO_RX2);

	// Disable all interrupt
    SPI_disableAllInterrupt(SPIA_peripheral_BASE);

    // Clear all interrupt
    SPI_clearAllInterruptStatus(SPIA_peripheral_BASE);

    // Enable interrupt
	SPI_enableInterrupt(SPIA_peripheral_BASE, SPI_INT_RXFF);

	// Close loop
	SPI_disableLoopback(SPIA_peripheral_BASE);

    // Enable the SSI module before initialization
    SPI_enableModule(SPIA_peripheral_BASE);

}
void SPIB_controller_init(void)
{
    // Disable the SSI module before initialization
	SPI_disableModule(SPIB_controller_BASE);

	// Initialize SSI
	SPI_setConfig(SPIB_controller_BASE,DEVICE_APBCLK_FREQ,SPI_PROT_POL0PHA0,\
			SPI_MODE_CONTROLLER,SPIB_controller_BITRATE,SPIB_controller_DATAWIDTH);

    // Sets the FIFO level at which interrupts are generated.
    SPI_setFIFOInterruptLevel(SPIB_controller_BASE, SPI_FIFO_TX2, SPI_FIFO_RX2);

	// Disable all interrupt
    SPI_disableAllInterrupt(SPIB_controller_BASE);

    // Clear all interrupt
    SPI_clearAllInterruptStatus(SPIB_controller_BASE);

    // Enable interrupt
	SPI_enableInterrupt(SPIB_controller_BASE, SPI_INT_TXFF);

	// Close loop
	SPI_disableLoopback(SPIB_controller_BASE);

    // Enable the SSI module before initialization
    SPI_enableModule(SPIB_controller_BASE);

}


#ifdef __cplusplus
}
#endif

