/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __SPI_LOOKBACK_DMA_H__
#define __SPI_LOOKBACK_DMA_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "inc/hw_memmap.h"

#define CONFIG_SPI_BASE                SPIA_BASE

#define CONFIG_SPI_TXBUF               ((uint32_t)(CONFIG_SPI_BASE + SPI_O_TXBUF))
#define CONFIG_SPI_RXBUF               ((uint32_t)(CONFIG_SPI_BASE + SPI_O_RXBUF))

#define CONFIG_SPI_BITRATE             (DEVICE_APBCLK_FREQ / 8U)
#define CONFIG_SPI_DATAWIDTH           (16U)
#define CONFIG_SPI_FIFO_LEVE           SPI_FIFO_TX8

#define CONFIG_DMA_BASE                DMA_BASE
#define CONFIG_DMA_TXCH_BASE           DMA_CH2_BASE
#define CONFIG_DMA_TXCH_IRQn           INT_DMA1_CH2

#define CONFIG_DMA_RXCH_BASE           DMA_CH1_BASE
#define CONFIG_DMA_RXCH_IRQn           INT_DMA1_CH1

#define CONFIG_SPI_TX_IRQn             INT_SPIA_TX
#define CONFIG_SPI_RX_IRQn             INT_SPIA_RX

#define CONFIG_SPI_DMA_TX_REQ_ID       DMAMUX_ReqId_spi0_tx
#define CONFIG_SPI_DMA_RX_REQ_ID       DMAMUX_ReqId_spi0_rx

void spi_init(void);
void spi_process(void);

#ifdef __cplusplus
}
#endif

#endif
