/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __W25QXX_H__
#define __W25QXX_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

typedef enum {
    w25q80  = 0XEF13,
    w25q16  = 0XEF14,
    w25q32  = 0XEF15,
    w25q64  = 0XEF16,
    w25q128 = 0XEF17
} w25qxx_id_t;

typedef struct __w25qxx {
    void (*pfn_cs_low) (void);
    void (*pfn_cs_high)(void);
    uint8_t (*pfn_send_and_recv_byte)(uint8_t data);
} w25qxx_dev_t;

uint16_t w25qxx_read_id(w25qxx_dev_t* p_dev);

uint16_t w25qxx_read_sr(w25qxx_dev_t* p_dev);

void w25qxx_write_sr(w25qxx_dev_t* p_dev, uint8_t sr);

void w25qxx_read(w25qxx_dev_t* p_dev, uint8_t* p_buffer,
                 uint32_t address, uint16_t size);

void w25qxx_write(w25qxx_dev_t* p_dev, uint8_t* p_buffer,
                  uint32_t address, uint16_t size);

void w25qxx_erase_chip(w25qxx_dev_t* p_dev);

void w25qxx_erase_sector(uint16_t address);

void w25qxx_pwr_down(w25qxx_dev_t* p_dev);

void w25qxx_weakup(w25qxx_dev_t* p_dev);

#ifdef __cplusplus
}
#endif

#endif /* W25Q128_H_ */
