 /*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __SPI_DMA_FLASH_H__
#define __SPI_DMA_FLASH_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "inc/hw_memmap.h"

#define CONFIG_SPI_BASE        SPIA_BASE
#define CONFIG_SPI_BITRATE     (DEVICE_APBCLK_FREQ / 60)
#define CONFIG_SPI_DATAWIDTH   (8U)

#define CONFIG_SPI_TXBUF               ((uint32_t)(CONFIG_SPI_BASE + SPI_O_TXBUF))
#define CONFIG_SPI_RXBUF               ((uint32_t)(CONFIG_SPI_BASE + SPI_O_RXBUF))

#define CONFIG_DMA_BASE                DMA_BASE
#define CONFIG_DMA_TXCH_BASE           DMA_CH2_BASE
#define CONFIG_DMA_TXCH_IRQn           INT_DMA1_CH2
#define CONFIG_DMA_RXCH_BASE           DMA_CH1_BASE
#define CONFIG_DMA_RXCH_IRQn           INT_DMA1_CH1
#define CONFIG_SPI_DMA_TX_REQ_ID       DMAMUX_ReqId_spi0_tx
#define CONFIG_SPI_DMA_RX_REQ_ID       DMAMUX_ReqId_spi0_rx

#if IS_GS32F00xx(0x30)

#define CONFIG_SPI_CLK_GPIO    (3U)
#define CONFIG_SPI_CLK         GPIO_3_SPIA_CLK

#define CONFIG_SPI_SIMO_GPIO   (2U)
#define CONFIG_SPI_SIMO        GPIO_2_SPIA_SIMO

#define CONFIG_SPI_SOMI_GPIO   (1U)
#define CONFIG_SPI_SOMI        GPIO_1_SPIA_SOMI

#define CONFIG_SPI_CS_GPIO     (0U)
#define CONFIG_SPI_CS          GPIO_0_GPIO0//GPIO_11_SPIA_STE

#endif /* IS_GS32F00xx(0x30) */

void dma_init(void);
void spi_init(void);
void spi_process(void);

#ifdef __cplusplus
}
#endif

#endif
