/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "sci_ex01_loopback.h"
#include "driverlib.h"
#include "printf.h"
#include "string.h"
#include "board_cfg.h"
#include "inc/hw_types.h"


#define SEND_DATA_LEN   10

uint8_t send_buff[SEND_DATA_LEN];
uint8_t rcv_buff[SEND_DATA_LEN];

void UART_Clock_Init();
void UART_GPIO_Init();
void SCI_Init(uint32_t SCIBase,uint32_t baud);

void UART_Init(uint32_t SCIBase,uint32_t baud)
{
	UART_Clock_Init();
	UART_GPIO_Init();
	SCI_Init(SCIBase,baud);
}

void sci_ex01_loopback_Example(uint32_t SCI_base)
{

    /* wait the Transmitter Shift Register empty */
    while(SCI_isSpaceAvailableNonFIFO(SCI_base) == 0);

    /* Fill data into send_data.
     * The Array send_buff: 0,1,2,3,...,10 */
    for (int i = 0; i < SEND_DATA_LEN; i++)
    {
    	send_buff[i] = i + 1;
    }


    /* Enable loopback */
    SCI_enableLoopback(SCI_base);

    for (int i = 0; i < SEND_DATA_LEN; i++)
    {
    	SCI_writeCharBlockingFIFO(SCI_base, send_buff[i]);
    }
    for (int i = 0; i < SEND_DATA_LEN; i++)
    {
    	rcv_buff[i] = SCI_readCharBlockingFIFO(SCI_base);
    }

    /* disable loopback. */
    SCI_disableLoopback(SCI_base);


    /* Compare whether the sending and receiving data are the same */
    for (int i = 0; i < SEND_DATA_LEN; i++)
    {
    	if (send_buff[i] != rcv_buff[i])	//ERROR
    	{
    	    char msg_buff[32];
    		sprintf(msg_buff, "SCI_BASE loopback test failthe send_data %d, rcv_data %d \r\n", send_buff[i], rcv_buff[i]);
    		UART_writeCharArray(SCI_base, msg_buff, strlen(msg_buff));
    		return;
    	}
    }

    UART_writeCharArray(SCI_base,"SCI_BASE loopback test OK \r\n", 28);
}


void UART_Clock_Init()
{
	/*
	 * Actual clock initialization is performed in Device_init()
	 * */
}
void UART_GPIO_Init()
{
    GPIO_setPadConfig(SCI_TX_GPIO, GPIO_PIN_TYPE_PULLUP);
    GPIO_setPadConfig(SCI_RX_GPIO, GPIO_PIN_TYPE_PULLUP);

    GPIO_setPinConfig(SCI_TX_GPIO_MUX);
    GPIO_setPinConfig(SCI_RX_GPIO_MUX);

}
void SCI_Init(uint32_t SCIBase,uint32_t baud)
{
	/* SCI RESET ensure SCI is IDLE */
    SCI_reset(SCIBase);

    SCI_setBaud(SCIBase, DEVICE_APBCLK_FREQ, baud);
    SCI_setInitConfig(SCIBase, SCI_CONFIG_PAR_NONE, SCI_STOP_1BIT, SCI_CHAR_8BITS);

    /* SCI clear Reset */
    SCI_ClearReset(SCIBase);

    SCI_enableFIFO(SCIBase);
    SCI_setFIFOInterruptLevel(SCIBase, SCI_FIFO_TX0, SCI_FIFO_RX1);

}

