#include <time.h>
#include <stdlib.h>
#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"
#include "string.h"
#include "stdio.h"



#define DMA_UART_RD_SIZE  8
#define DMA_UART_BUF_SIZE 4095
#define LED_STA_PIN     GPIO_PIN_LED2
/*******************************************************************************
 *                            Define for DMA_MUX
 * DIG_SYS_CTRL_PARAM base 0x40370000
 * DMA_MUX_CH0 offset 0x00000050U
 * DMA_MUX_CH1 offset 0x00000054U
 * DMA_MUX_CH2 offset 0x00000058U
 * ......
 * dma_req_sync[24] = uart_dma_req_sync[2] = uart1_dma_rx_req
 * dma_req_sync[25] = uart_dma_req_sync[3] = uart1_dma_tx_req
 *******************************************************************************/
/**
 * \brief   test DMA transfer from SRAM to UART
 *
 * \param   none
 *
 * \retval  None
 */
char Dma_UartTxBuf[DMA_UART_BUF_SIZE];
char tmpstr[32] = {0};
uint64_t ctrl = 0,config = 0;

void DMA1_INTR_IRQHandler(void)
{
	volatile uint32_t status = DMA_getInterruptStatus(DMA_CH1_BASE);
	char* prompt_info = "please send 8 characters to DMA by UART:\r\n";

	DMA_clearInterrupt(DMA_CH1_BASE, status);
	DMA_stopChannel(DMA_CH1_BASE);
	UART_writeCharArray(LOG_SCI_BASE, prompt_info, strlen(prompt_info));
}

void DMA2_INTR_IRQHandler(void)
{
	volatile uint32_t status = DMA_getInterruptStatus(DMA_CH2_BASE);
	uint32_t i = 0;
	char* prompt_info = "recv characters:\r\n";

	DMA_clearInterrupt(DMA_CH2_BASE, status);
	DMA_stopChannel(DMA_CH2_BASE);
	UART_writeCharArray(LOG_SCI_BASE, prompt_info, strlen(prompt_info));

	for (i = 0; i < 8; i++)
	{
		UART_writeCharBlockingFIFO(LOG_SCI_BASE, tmpstr[i]);
	}
}


void uart_dma_tx(void)
{
    uint32_t i;
    DMA_ConfigParams dmaCfg = {0};

    for(i=0; i < DMA_UART_BUF_SIZE; i++)
    {
        Dma_UartTxBuf[i] = (0x40+(i%26));
    }
    Dma_UartTxBuf[4094] = '\r';
    Dma_UartTxBuf[4095] = '\n';

    dmaCfg.enableInterrupt = 1;
    dmaCfg.srcAddr = (uint32_t)(&Dma_UartTxBuf[0]);
    dmaCfg.destAddr = (SCIA_BASE + SCI_O_RBR_THR_DLL);
    dmaCfg.blockTS = DMA_UART_BUF_SIZE;
    dmaCfg.ttfc    = DMA_TT_FC_1_M2P_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;
    dmaCfg.destHardInf = DMA_HKS_HARD_INF_0;
    dmaCfg.dmaDstReqId = DMAMUX_ReqId_scia_tx;
    /* Clear INT flag set in previous operation */
    /* Enable the IRQ so that we can poll the Status_Tfr flag */
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);
    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_SRCTRAN);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
}

void uart_dma_rx()
{
    uint32_t i;
    DMA_ConfigParams dmaCfg = {0};
    memset(tmpstr, 0, DMA_UART_RD_SIZE);

    DMA_stopChannel(DMA_CH2_BASE);
    dmaCfg.enableInterrupt = 1;
    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_scia_rx;
    dmaCfg.srcAddr = (SCIA_BASE + SCI_O_RBR_THR_DLL);
    dmaCfg.destAddr = (uint32_t)(&tmpstr[0]);
    dmaCfg.blockTS = DMA_UART_RD_SIZE;
    dmaCfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;
    dmaCfg.srcHardInf = DMA_HKS_HARD_INF_0;

    DMA_configChannel(DMA_CH2_BASE, &dmaCfg);

    /* Clear INT flag set in previous operation */
    /* Enable the IRQ so that we can poll the Status_Tfr flag */
    DMA_unMaskInterrupt(DMA_CH2_BASE, DMA_INT_TFR);

}




int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;
    uint32_t i = 0;
    char* prompt_info = "Send 4095 char to UART by DMA:\r \n";

    Device_init();

    SCI_reset(LOG_SCI_BASE);

    UartPrint_init(LOG_SCI_BASE, 115200);

    SCI_ClearReset(LOG_SCI_BASE);

    Interrupt_register(INT_DMA1_CH1, DMA1_INTR_IRQHandler);
    Interrupt_enable(INT_DMA1_CH1);
    Interrupt_register(INT_DMA1_CH2, DMA2_INTR_IRQHandler);
    Interrupt_enable(INT_DMA1_CH2);
    __enable_irq();
    DMA_initController(DMA_BASE);
    UART_writeCharArray(LOG_SCI_BASE, prompt_info, strlen(prompt_info));
    uart_dma_tx();
    uart_dma_rx();
    DMA_startChannel(DMA_CH1_BASE);
    DMA_startChannel(DMA_CH2_BASE);
    while (1);

}

