/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "string.h"
#include "board_cfg.h"
#include "inc/hw_types.h"
#include "sci_ex09_printf.h"


#define SEND_DATA_LEN   10

uint8_t send_buff[SEND_DATA_LEN];
uint8_t rcv_buff[SEND_DATA_LEN];

void UART_Clock_Init();
void UART_GPIO_Init();
void SCI_Init(uint32_t SCIBase,uint32_t baud);

void UART_Init(uint32_t SCIBase,uint32_t baud)
{
	UART_Clock_Init();
	UART_GPIO_Init();
	SCI_Init(SCIBase,baud);
}

void sci_ex09_loopback_Example(uint32_t SCI_base)
{
    printf("This is a test print statement for printf.\n");

    log_trace("This is a test print statement for log_trace level,log level:%d\n",LOG_TRACE);
    log_debug("This is a test print statement for log_debug level,log level:%d\n",LOG_DEBUG);
    log_info("This is a test print statement for log_info level,log level:%d\n",LOG_INFO);
    log_warn("This is a test print statement for log_warn level,log level:%d\n",LOG_WARN);
    log_error("This is a test print statement for log_error level,log level:%d\n",LOG_ERROR);
    log_fatal("This is a test print statement for log_fatal level,log level:%d\n",LOG_FATAL);
}


void UART_Clock_Init()
{
	/*
	 * Actual clock initialization is performed in Device_init()
	 * */
}
void UART_GPIO_Init()
{
    GPIO_setPadConfig(SCI_TX_GPIO, GPIO_PIN_TYPE_PULLUP);
    GPIO_setPadConfig(SCI_RX_GPIO, GPIO_PIN_TYPE_PULLUP);

    GPIO_setPinConfig(SCI_TX_GPIO_MUX);
    GPIO_setPinConfig(SCI_RX_GPIO_MUX);

}
void SCI_Init(uint32_t SCIBase,uint32_t baud)
{
	/* SCI RESET ensure SCI is IDLE */
    SCI_reset(SCIBase);

    SCI_setBaud(SCIBase, DEVICE_APBCLK_FREQ, baud);
    SCI_setInitConfig(SCIBase, SCI_CONFIG_PAR_NONE, SCI_STOP_1BIT, SCI_CHAR_8BITS);

    /* SCI clear Reset */
    SCI_ClearReset(SCIBase);

    SCI_enableFIFO(SCIBase);
    SCI_setFIFOInterruptLevel(SCIBase, SCI_FIFO_TX0, SCI_FIFO_RX1);

}

