/*
 * sci_fifo_interrupts.c
 *
 *  Created on: 2025 May 12
 *      Author: hpec
 */
#include "sci_fifo_interrupts.h"

#define my_sci_base SCIA_BASE

#define SEND_DATA_LEN   128

/*Global*/
uint8_t send_data[SEND_DATA_LEN + 2];
uint8_t rcv_data[SEND_DATA_LEN];
uint32_t rcv_data_len = 0;

volatile uint8_t SCI_test_finish = 0;

void uart_pinmux_init(uint32_t base)
{
	if (base == SCIA_BASE)
	{
		GPIO_setPinConfig(SCIA_TX_PIN);
		GPIO_setPinConfig(SCIA_RX_PIN);

		GPIO_setPadConfig(28, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(29, GPIO_PIN_TYPE_PULLUP);
	}
	else if (base == SCIB_BASE)
	{
		GPIO_setPinConfig(SCIB_TX_PIN);
		GPIO_setPinConfig(SCIB_RX_PIN);

		GPIO_setPadConfig(14, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(15, GPIO_PIN_TYPE_PULLUP);
	}
}

void uart_init(uint32_t SCI_Base, uint32_t Baud)
{
    SCI_performSoftwareReset(SCI_Base);


    /*Configure SCIA for echoback.*/
    SCI_setConfig(SCI_Base, DEVICE_APBCLK_FREQ, Baud, (SCI_CONFIG_WLEN_8 |
                                                        SCI_CONFIG_STOP_ONE |
                                                        SCI_CONFIG_PAR_NONE));
    SCI_resetChannels(SCI_Base);
    SCI_resetRxFIFO(SCI_Base);
    SCI_resetTxFIFO(SCI_Base);
    SCI_clearInterruptStatus(SCI_Base, SCI_INT_TXFF | SCI_INT_RXFF);

    SCI_enableModule(SCI_Base);
    SCI_performSoftwareReset(SCI_Base);

    SCI_enableFIFO(SCI_Base);
    /* Enable the TXRDY and RXRDY interrupts. */
    SCI_enableInterrupt(SCI_Base, SCI_INT_TXFF | SCI_INT_RXFF);
    SCI_setFIFOInterruptLevel(SCI_Base, SCI_FIFO_TX0, SCI_FIFO_RX8);
    /* Clear the SCI interrupts before enabling them. */
    SCI_clearInterruptStatus(SCI_Base, SCI_INT_TXFF | SCI_INT_RXFF);
}

void sciaTXFIFOISR(void)
{

	char *prompt_info = "please enter some chars: \r\n";

	UART_writeCharArray(my_sci_base, prompt_info, strlen(prompt_info));

	SCI_clearInterruptStatus(my_sci_base, SCI_INT_TXFF);

    /* Disable the TXRDY interrupt. */
    SCI_disableInterrupt(my_sci_base, SCI_INT_TXFF);

    __DSB();
}


/* sciaRXFIFOISR - SCIA Receive FIFO ISR */
void sciaRXFIFOISR(void)
{
	uint8_t i= 0;
	char *prompt_info = "rcv_data: ";
	uint8_t rcv_data_len = 0;
	while(!SCI_getRxFIFOStatus(my_sci_base) == SCI_FIFO_RX0)
	{
		if (rcv_data_len >= SEND_DATA_LEN)
		{
			prompt_info = 	"rcv buf is not enough \r\n";
			UART_writeCharArray(my_sci_base, prompt_info, strlen(prompt_info));

			return;
		}

		rcv_data[rcv_data_len++] = SCI_readCharBlockingFIFO(my_sci_base);
		DEVICE_DELAY_US(80);
		}
		if (rcv_data_len != 0&&(SCI_getRxFIFOStatus(my_sci_base) == SCI_FIFO_RX0))
		{
			rcv_data[rcv_data_len++] = '\r';
			rcv_data[rcv_data_len] = '\n';
			UART_writeCharArray(my_sci_base, prompt_info, strlen(prompt_info));
			UART_writeCharArray(my_sci_base, rcv_data, strlen(rcv_data));

			for (i = 0; i < rcv_data_len; i++)
			{
				rcv_data[i] = 0;
			}

			rcv_data_len = 0;
			SCI_enableInterrupt(my_sci_base, SCI_INT_TXFF);

			SCI_test_finish = 1;
		}

	SCI_clearInterruptStatus(my_sci_base, SCI_INT_RXFF);
	
    __DSB();
}
