// See LICENSE for license details.
#include "sci_loopback_txdelay_polling.h"

static uint32_t g_SCI_base = SCIA_BASE;

int main(void)
{
	char* msg = "\0";
	uint16_t sData = 0;
	uint16_t rData = 0;
	uint8_t sDatas[5] = {0};
	uint8_t rDatas[5] = {0};
	uint16_t txdly = 0;
	uint16_t i = 0;
    Device_init();

    uart_pinmux_init(g_SCI_base);

	uart_init(g_SCI_base, 115200);

    sDatas[0] = 0x31;
    sDatas[1] = 0x32;
    sDatas[2] = 0x33;
    sDatas[3] = 0x34;
    sDatas[4] = 0x35;

    __enable_irq();

    for (txdly = 0; txdly < 255;txdly++)
    {
    	int j = 0;

    	UART_writeCharArray(g_SCI_base, sDatas, 5);
    	while( (HWREGH(g_SCI_base+SCI_O_CTL2) & SCI_CTL2_TXEMPTY) != SCI_CTL2_TXEMPTY );

    	UART_readCharArray(g_SCI_base, rDatas, 5);

    	/* Check received data against sent data */
    	for(j = 0;j < 5;j++)
    	{
    		if(sDatas[i] != rDatas[i])
    		{
    			/* Something went wrong. rData doesn't contain expected data. */
    			SCI_disableLoopback(g_SCI_base);
    			msg = "!!!!!!!!!!!!!!!!!!!!!!!!!!!--- Baud Rate ERR ---!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\r";
    			UART_writeCharArray(g_SCI_base, msg, strlen(msg));
    			return 0;

    		}
    	}

    	SCI_resetTxFIFO(g_SCI_base);
    	SCI_setTxFifoTransmitDelay(g_SCI_base, 0);
    }

    SCI_disableLoopback(g_SCI_base);

    msg = "\n\r=== Loopback Polling Txdelay Succeed ===\n\r";
    UART_writeCharArray(g_SCI_base, msg, strlen(msg));
    msg = "\n\r=== Loopback Polling Txdelay End ===\n\r";
    UART_writeCharArray(g_SCI_base, msg, strlen(msg));
    while(1);
    return 0;
}
