// See LICENSE for license details.
#include "sci_dma_timeout.h"

extern uint32_t g_SCI_base;

int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;
    uint32_t i = 0;
    char* msg = "\n\r============================= START SCI_EX11_LOOPBACK_DMA TIMEOUT =============================\n\r";

    Device_init();

    uart_pinmux_init(g_SCI_base);

    uart_init(g_SCI_base, 115200);

	Interrupt_register(INT_SCIA_RX, SCIx_RX_INTR_IRQHandler);
	Interrupt_enable(INT_SCIA_RX);

    DisableDCache();

    __enable_irq();
	UART_writeCharArray(g_SCI_base, msg, strlen(msg));
    uart_dma_tx();
    uart_dma_rx();
    msg = "SCI_test08_dma end \r\n";
    UART_writeCharArray(g_SCI_base, msg, strlen(msg));
    while (1)
    {

    }
}
