// See LICENSE for license details.
#include "sci_idle_line_slv.h"

extern uint32_t g_SCI_base;
extern uint8_t buff[64];
extern uint16_t cnt;
extern volatile uint8_t flag_n;
extern uint16_t interrupt_cnt;

int main(void)
{
    uint8_t i = 0;

    Device_init();

    uart_pinmux_init(g_SCI_base);
    uart_init(g_SCI_base, 115200);

    Interrupt_register(INT_SCIA_TX, SCIx_TX_INTR_IRQHandler);
    Interrupt_register(INT_SCIA_RX, SCIx_RX_INTR_IRQHandler);

	char *prompt_info = "the device address is 0x59(Y), and You will enter msg, which end with \\n: \r\n";

	UART_writeCharArray(g_SCI_base, prompt_info, strlen(prompt_info));

    Interrupt_enable(INT_SCIA_TX);
    Interrupt_enable(INT_SCIA_RX);
    __enable_irq();


    while(1)
    {
        while(flag_n)
        {
            flag_n=0;

            UART_writeCharArray(g_SCI_base, buff, cnt);

            for (i = 0; i < cnt; i++)
            {
            	buff[i] = 0;
            }

            SCI_enableSleepMode(g_SCI_base);

            cnt=0;


            if (interrupt_cnt != 0)
            {
            	UART_writeCharBlockingFIFO(g_SCI_base, interrupt_cnt + '0');
            }

        }

    }

}
