/*
 * sci_address_bit_master.c
 *
 *  Created on: 2025 May 13
 *      Author: hpec
 */
#include "sci_address_bit_master.h"

uint32_t g_SCI_base = SCIA_BASE;

uint32_t rcv_data_len = 0;
uint8_t SCI_test_finish = 0;
uint16_t buff[64] = {0};
uint8_t flag_r=0;
uint8_t flag_n=0;
uint16_t addres = 0;
uint16_t address_flag = 0;
uint16_t cnt = 0;


void uart_pinmux_init(uint32_t base)
{
	if (base == SCIA_BASE)
	{
		GPIO_setPinConfig(SCIA_TX_PIN);
		GPIO_setPinConfig(SCIA_RX_PIN);

		GPIO_setPadConfig(28, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(29, GPIO_PIN_TYPE_PULLUP);
	}
	else if (base == SCIB_BASE)
	{
		GPIO_setPinConfig(SCIB_TX_PIN);
		GPIO_setPinConfig(SCIB_RX_PIN);

		GPIO_setPadConfig(14, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(15, GPIO_PIN_TYPE_PULLUP);
	}
}

void uart_init(uint32_t SCI_Base, uint32_t Baud)
{
	SCI_performSoftwareReset(SCI_Base);
	SCI_setConfig(SCI_Base, DEVICE_APBCLK_FREQ, Baud,(SCI_CONFIG_WLEN_8|SCI_CONFIG_STOP_ONE|SCI_CONFIG_PAR_NONE));
	SCI_resetChannels(SCI_Base);
	SCI_clearInterruptStatus(SCI_Base, SCI_INT_TXFF | SCI_INT_RXFF);
	SCI_enableFIFO(SCI_Base);
	SCI_setFIFOInterruptLevel(SCI_Base, SCI_FIFO_TX0, SCI_FIFO_RX1);
	SCI_enableInterrupt(SCI_Base, SCI_INT_TXFF | SCI_INT_RXFF);
	SCI_enableModule(SCI_Base);
	SCI_enableSleepMode(SCI_Base);
	SCI_performSoftwareReset(SCI_Base);
}

void SCIx_RX_INTR_IRQHandler(void)
{

    if(address_flag == 0 && (HWREGH(g_SCI_base + SCI_O_RXST) & 0x02))
    {
        addres = SCI_readCharBlockingFIFO(g_SCI_base);
    }


    if(address_flag == 0 && addres == 0x59)
    {
        SCI_disableSleepMode(g_SCI_base);
        address_flag = 1;
        SCI_clearInterruptStatus(g_SCI_base, SCI_INT_RXFF);
        return;
    }

    if(address_flag == 1)
    {
        buff[cnt] = SCI_readCharBlockingFIFO(g_SCI_base);
    }


    if(flag_r==0)
    {
        if(buff[cnt]=='\r')
        {
            flag_r = 1;
        }
    }
    else
    {
        if(buff[cnt]== '\n')
        {
            flag_n = 1;
            address_flag = 0;
        }
        else
        {
            flag_r = 0;
        }
    }

    if (address_flag == 1)
    {
    	cnt++;
    }

    SCI_clearInterruptStatus(g_SCI_base, SCI_INT_RXFF);
    
    __DSB();
}
