/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    dma_ex00_m2m_scatter_gather_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
//#include "stdio.h"
#include <printf.h>
#include "string.h"
#include "device.h"
#include "dma_ex00_m2m_scatter_gather_board.h"

#define DMA_BUF_SIZE 32


uint8_t scatterData[DMA_BUF_SIZE] = {1,2,3,4,0,0,0,0,
                                      5,6,7,8,0,0,0,0,
                                      9,10,11,12,0,0,0,0,
                                      13,14,15,16,0,0,0,0};

uint8_t gatherData[DMA_BUF_SIZE] = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16};


void dma_ex00(void)
{
    DMA_ConfigParams dmaCfg = {0};
    uint8_t testBuff[DMA_BUF_SIZE] = {0};

    //dma source_scatter test
    /* Initialize source test data */
    memset(testBuff, 0 , DMA_BUF_SIZE);

    /* DMA global enable */
    DMA_initController(DMA_BASE);

    /* Stop DMA channel first - why the DMA channel is still pending after reset? */
    DMA_stopChannel(DMA_CH1_BASE);

    memset(&dmaCfg, 0, sizeof(dmaCfg));
    dmaCfg.enableInterrupt = 1;
    dmaCfg.srcAddr = (uint32_t)scatterData;
    dmaCfg.destAddr = (uint32_t)testBuff;

    dmaCfg.blockTS = 16;
    dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_4;
    dmaCfg.destBtl = DMA_BTL_4;
    dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;

    dmaCfg.srcGatherInterval = 4;
    dmaCfg.srcGatherCount = 4;
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_TFR);

    /* DMA channel enable */
    DMA_startChannel(DMA_CH1_BASE);

    while((DMA_getInterruptStatus(DMA_CH1_BASE) & DMA_INT_TFR) == 0);

    if(memcmp(gatherData, testBuff, sizeof(gatherData)) == 0)
    {
        printf("DMA MEM SCATTER test[OK].\r\n");
    }
    else
    {
        printf("DMA MEM SCATTER test[Fail].\r\n");
    }

    //dma dest scatter
    /* Initialize source test data */
    memset(testBuff, 0 , DMA_BUF_SIZE);

    /* DMA global enable */
    DMA_initController(DMA_BASE);

    /* Stop DMA channel first - why the DMA channel is still pending after reset? */
    DMA_stopChannel(DMA_CH1_BASE);

    memset(&dmaCfg, 0, sizeof(dmaCfg));
    dmaCfg.enableInterrupt = 1;
    dmaCfg.srcAddr = (uint32_t)gatherData;
    dmaCfg.destAddr = (uint32_t)testBuff;

    dmaCfg.blockTS = 16;
    dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_4;
    dmaCfg.destBtl = DMA_BTL_4;
    dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;

    dmaCfg.destScatterCount = 4;
    dmaCfg.destScatterInterval = 4;
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_TFR);

    /* DMA channel enable */
    DMA_startChannel(DMA_CH1_BASE);

    while((DMA_getInterruptStatus(DMA_CH1_BASE) & DMA_INT_TFR) == 0);

    if(memcmp(scatterData, testBuff, sizeof(gatherData)) == 0)
    {
        printf("DMA MEM GATHER test[OK].\r\n");
    }
    else
    {
        printf("DMA MEM GATHER test[Fail].\r\n");
    }

    printf("test_dma_ex02_m2m_scatter_gather end \r\n");
}

#ifdef __cplusplus
}
#endif

