/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
//#############################################################################
//
// FILE:   pto_qepdiv.h
//
// TITLE:  Prototypes and Definitions for the Position Manager PTO
//         QEPDiv Library
//
//
//#############################################################################


#ifndef PTO_QEPDIV_H
#define PTO_QEPDIV_H

//
// Library of functions
//
#include <stdint.h>

//
// Function Prototypes
//
extern void pto_qepdiv_setupPeriph(void);
extern uint16_t pto_qepdiv_config(uint16_t divider, uint16_t indexWidth);
extern void pto_qepdiv_startOperation(uint16_t run);
extern void pto_qepdiv_reset(void);
extern void pto_qepdiv_initCLBXBAR(void);
extern void pto_qepdiv_resetCLB(void);

#endif // PTO_QEPDIV_H

//
// End of File
//
