/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @example: can_loopback
 * @Language:English
 * @encode:
 * @brief:
 * This example demonstrates the CAN loopback transmission test.
 * Polling for sending messages involves an ID of 0xc0 and a data segment from 0 to 7.
 * Reading the messages is done in the interrupt service function and is checked and read.
 * The CAN 2.0 protocol is used. The baud rate is set to 1M and the sampling point is 80%.
 */

/*
 * @example: can_loopback
 * @Language:Chinese
 * @encode:GBK
 * @brief:
 *	ʾCANշԡ
 *	ѯͱidΪ0xc0 ݶ07
 *	ȡ жϷм鲢ȡ
 *	ʹCAN2.0Э Ϊ1M 80%
 */

#include "device.h"
#include "can_loopback.h"

CAN_TxMessage_t TxMsgBuf0 = {0};
#define Delay_value  10000000

int main(void)
{
	uint32_t i;
	uint32_t Delay = Delay_value;

	Device_init();

	__disable_irq();

	UartPrint_init(LOG_SCI_BASE, 115200);

	GPIO_setPinConfig(CAN_RX_PIN);
	GPIO_setPinConfig(CAN_TX_PIN);

	can_ctrl_init();

	__enable_irq();

	TxMsgBuf0.dlc = CAN_DATA_LENGTH_8;
	TxMsgBuf0.id = 0xc0;

	for (i = 0; i < CAN_getMessageLength(TxMsgBuf0.dlc); i++) {
		TxMsgBuf0.data[i] = i;
	}

	while (1) {
		CAN_transmitHighPriorityMsg(CAN_BASE, &TxMsgBuf0);
		while (Delay--);
		Delay = Delay_value;
	}
}
