/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @example: canfd_transfer
 * @Language:English
 * @encode:
 * @brief:
 * This routine demonstrates the normal mode of CANFD transmission and reception.
 * In this process, after receiving the message, the message ID is sent out again in the interrupt service function for message transmission and reception.
 * The CANFD protocol is used. The baud rate is set to 1M for the arbitration segment and 4M for the data segment. The sampling point is 80%.
 */

/*
 * @example: canfd_transfer
 * @Language:Chinese
 * @encode:GBK
 * @brief:
 *	ʾCANFDģʽշ
 *	ڽյĺѱID ٷͳȥ жϷȥշ
 *	ʹCANFDЭ Ϊ ٲö1M ݶΪ4M 80%
 */

#include "device.h"
#include "canfd_transfer.h"
#include "log.h"

int main(void)
{
	Device_init();

	__disable_irq();

	UartPrint_init(LOG_SCI_BASE, 115200);

	GPIO_setPinConfig(CAN_RX_PIN);
	GPIO_setPinConfig(CAN_TX_PIN);

	can_ctrl_init();

	__enable_irq();

	while (1);
}
