/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    cmpss_ex1_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


#include "printf.h"
#include "cmpss_ex1_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define PWM1_TIMER_MIN     500U
#define PWM1_TIMER_MAX     8000U
#define EPWM_TIMER_UP      1U
#define EPWM_TIMER_DOWN    0U

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */



/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/**
 * \brief   "Error function" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void error()
{

}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{

	ASysCtl_setAnaTopSpare(0, 0x0020);
	ASysCtl_setCmpSpare(0x20000000);

	//Because both gpio252 and gpio20 can be used B5   but   you need  selsect  one of them    at  the same time
	//so give you  two  mode use


	//  the first select    gpio252 as the B5  ANALOG    gpio20 as the  digital gpio
	GPIO_setPinConfig(GPIO_252_GPIO252);

	GPIO_setAnalogMode(252, GPIO_ANALOG_ENABLED);

	GPIO_setPinConfig(GPIO_20_GPIO20);

	GPIO_setAnalogMode(20, GPIO_ANALOG_DISABLED);



	//  the second select    gpio20 as the B5  ANALOG    gpio252 as the  digital gpio
//	GPIO_setPinConfig(GPIO_252_GPIO252);
//
//    GPIO_setAnalogMode(252, GPIO_ANALOG_ENABLED);
//
//    GPIO_setPinConfig(GPIO_20_GPIO20);
//
//	GPIO_setAnalogMode(20, GPIO_ANALOG_DISABLED);




	// OUTPUTXBAR3 -> myOUTPUTXBAR0 Pinmux
	GPIO_setPinConfig(myOUTPUTXBAR0_OUTPUTXBAR_PIN_CONFIG);

}

//*****************************************************************************
//
// CMPSS Configurations
//
//*****************************************************************************
void CMPSS_init(){
	myCMPSS0_init();
}

void myCMPSS0_init(){
    // Select the value for CMP1LPMXSEL.
    ASysCtl_selectCMPLPMux(ASYSCTL_CMPLPMUX_SELECT_1,5U);



    // Sets the configuration for the low comparator.
    CMPSS_configLowComparator(myCMPSS0_BASE,(CMPSS_INSRC_DAC));

    // Sets the configuration for the internal comparator DACs.
    CMPSS_configDAC(myCMPSS0_BASE,(CMPSS_DACVAL_SYSCLK | CMPSS_DACREF_VDDA | CMPSS_DACSRC_SHDW));


    // Sets the value of the internal DAC of the low comparator.
    CMPSS_setDACValueLow(myCMPSS0_BASE,2048U);


    // Configures the digital filter of the low comparator.
    CMPSS_configFilterLow(myCMPSS0_BASE, 0U, 1U, 1U);

    // Sets the output signal configuration for the low comparator.
    CMPSS_configOutputsLow(myCMPSS0_BASE,(CMPSS_TRIPOUT_ASYNC_COMP | CMPSS_TRIP_ASYNC_COMP));

    // Sets the comparator hysteresis settings.
    CMPSS_setHysteresis(myCMPSS0_BASE,0U);

    // Configures the comparator subsystem's ramp generator.
    CMPSS_configRamp(myCMPSS0_BASE,0U,0U,0U,1U,true);

    // Disables reset of HIGH comparator digital filter output latch on PWMSYNC
    CMPSS_disableLatchResetOnPWMSYNCHigh(myCMPSS0_BASE);

    // Disables reset of LOW comparator digital filter output latch on PWMSYNC
    CMPSS_disableLatchResetOnPWMSYNCLow(myCMPSS0_BASE);

    // Sets the ePWM module blanking signal that holds trip in reset.
    CMPSS_configBlanking(myCMPSS0_BASE,1U);

    // Disables an ePWM blanking signal from holding trip in reset.
    CMPSS_disableBlanking(myCMPSS0_BASE);

    // Configures whether or not the digital filter latches are reset by PWMSYNC
    CMPSS_configLatchOnPWMSYNC(myCMPSS0_BASE,false,false);

    // Enables the CMPSS module.
    CMPSS_enableModule(myCMPSS0_BASE);

    // Delay for CMPSS DAC to power up.
    DEVICE_DELAY_US(500);
}



//*****************************************************************************
//
// OUTPUTXBAR Configurations
//
//*****************************************************************************
void OUTPUTXBAR_init(){
	myOUTPUTXBAR0_init();
}

void myOUTPUTXBAR0_init(){
	XBAR_setOutputLatchMode(OUTPUTXBAR_BASE, myOUTPUTXBAR0, false);
	XBAR_invertOutputSignal(OUTPUTXBAR_BASE, myOUTPUTXBAR0, false);

	//Mux configuration
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, myOUTPUTXBAR0, XBAR_OUT_MUX01_CMPSS1_CTRIPOUTL);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE, myOUTPUTXBAR0, XBAR_MUX01);
}

//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	PinMux_init();
	CMPSS_init();
	OUTPUTXBAR_init();
}


#ifdef __cplusplus
}
#endif
