/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    Test_CpuCRC.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "GS32F00xx.h"
#include <CRC_ex03_interrupt_board.h>
#include "stdio.h"
#include "crc.h"
#include "interrupt.h"
#include "printf.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

uint32_t CRC_data_in_32bit[CPUDATA_SIZE] = {0x00001111,0x11110000,0x00000000,0x11111111};
uint32_t CRC_data_in_24bit[CPUDATA_SIZE] = {0x00000011,0x00000022,0x00000033,0x00000044};
uint32_t CRC_data_in_16bit[CPUDATA_SIZE] = {0x00001111,0x00002222,0x00003333,0x00004444};
uint32_t CRC_data_in_8bit[CPUDATA_SIZE] = {0x00000011,0x00000022,0x00000033,0x00000044};
uint32_t CRC_data_in_7bit = 0x0000005f;

uint32_t CRC_result[5] = {0,0,0,0,0};
volatile uint32_t watchResult = 0;
uint16_t crcErr = 0;
uint16_t crcRight = 0;
uint16_t intDoneCnt = 0;
uint16_t intFailCnt = 0;
uint16_t intDoneErrCnt = 0;
uint16_t intDoneState[5] = {0,0,0,0,0};

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */



/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

 /**
 * \brief   Test CPUCRC
 * \param   none
 * \retval  None
 */
 void Test_CpuCRC(void)
{

	INTERRUPTCRC_init();
/**********************************************************/
	/* Configuration */
	CRC_ConfigParams crcConfigParams;
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_32BIT;
	crcConfigParams.polyValue = 0x04C11DB7;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0x41478365;
	crcConfigParams.mode = CRC_RX_MODE;
	crcConfigParams.revin = CRC_REVIN_BYTEREV;
	crcConfigParams.enableDoneInterrupt = 1;
	crcConfigParams.enableFailInterrupt = 1;
	CRC_initConfig(CRC_BASE, crcConfigParams);

	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);
	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_32bit[i]);
	}
	CRC_result[0] = CRC_getResult(CRC_BASE);

	/* Check if the result is right */
	if(CRC_result[0] == 0x41478365){/*32poly 04C11DB7*/
		crcRight |= 0x01;
	}
	else{
		crcErr |= 0x01;
	}
/**********************************************************/
	/* Configuration */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_24BIT;
	crcConfigParams.polyValue = 0x00864CFB;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0xB42F7C;
	crcConfigParams.mode = CRC_RX_MODE;
	crcConfigParams.revin = CRC_REVIN_BYTEREV;
	crcConfigParams.enableDoneInterrupt = 1;
	crcConfigParams.enableFailInterrupt = 1;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);
	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_24bit[i]);
	}
	CRC_result[1] = CRC_getResult(CRC_BASE);
	/* Check if the result is right */
	if(CRC_result[1] == 0xB42F7C){ /*24poly 864CFB*/
		crcRight |= 0x02;
	}
	else{
		crcErr |= 0x02;
	}
/**********************************************************/
	/* Configuration */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_16BIT;
	crcConfigParams.polyValue = 0x00008005;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0x0000CF3C;
	crcConfigParams.mode = CRC_RX_MODE;
	crcConfigParams.revin = CRC_REVIN_BYTEREV;
	crcConfigParams.enableDoneInterrupt = 1;
	crcConfigParams.enableFailInterrupt = 1;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);
	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_16bit[i]);
	}
	CRC_result[2] = CRC_getResult(CRC_BASE);
	/* Check if the result is right */
	if(CRC_result[2] == 0x0000CF3C){ /*16poly 8005*/
		crcRight |= 0x04;
	}
	else{
		crcErr |= 0x04;
	}
/**********************************************************/
	/* Configuration */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_8BIT;
	crcConfigParams.polyValue = 0x00000007;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0x00000053;
	crcConfigParams.mode = CRC_RX_MODE;
	crcConfigParams.revin = CRC_REVIN_BYTEREV;
	crcConfigParams.enableDoneInterrupt = 1;
	crcConfigParams.enableFailInterrupt = 1;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);
	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_8bit[i]);
	}
	CRC_result[3] = CRC_getResult(CRC_BASE);
	
	/* Check if the result is right */
	if(CRC_result[3] == 0x53){ /*8poly 07*/
		crcRight |= 0x08;
	}
	else{
		crcErr |= 0x08;
	}

/**********************************************************/
	/* Configuration */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_7BIT;
	crcConfigParams.polyValue = 0x00000009;
	crcConfigParams.dataSize = 1;
	crcConfigParams.goldenValue = 0x00000054;
	crcConfigParams.mode = CRC_RX_MODE;
	crcConfigParams.revin = CRC_REVIN_BYTEREV;
	crcConfigParams.enableDoneInterrupt = 1;
	crcConfigParams.enableFailInterrupt = 1;

	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);
	/*DR INPUT*/
	CRC_writeData(CRC_BASE,CRC_data_in_7bit);

	CRC_result[4] = CRC_getResult(CRC_BASE);

	/* Check if the result is right */
	if(CRC_result[4] == 0x54){ /*7poly 09*/
		crcRight |= 0x10;
	}
	else{
		crcErr |= 0x10;
	}
}

void CRC_INT_IRQHandler(void)
{
	//go to CRC calculation interrupt
	if(CRC_getIntFlagDone(CRC_BASE) == 1)
	{
		intDoneCnt++;
		delay_us(100);
		if(CRC_getResult(CRC_BASE) == 0x41478365){
			intDoneState[0] = 1;
		}
		else if(CRC_getResult(CRC_BASE) == 0xB42F7C){
			intDoneState[1] = 1;
		}
		else if(CRC_getResult(CRC_BASE) == 0xCF3C){
			intDoneState[2] = 1;
		}
		else if(CRC_getResult(CRC_BASE) == 0x53){
			intDoneState[3] = 1;
		}
		else if(CRC_getResult(CRC_BASE) == 0x54){
			intDoneState[4] = 1;
		}
		else{
			intDoneErrCnt++;
		}
		CRC_clearIntRawFlagDone(CRC_BASE);
	}
	if(CRC_getIntFlagFail(CRC_BASE) == 1){
		intFailCnt++;
		CRC_clearIntRawFlagFail(CRC_BASE);
	}
}

// INTERRUPT Configurations
void INTERRUPTCRC_init(void)
{
  	Interrupt_register(INT_CRC, CRC_INT_IRQHandler);
  	Interrupt_enable(INT_CRC);
  	__enable_irq();
}

void delay_us(uint32_t delay_us)
{    
  volatile unsigned int num;
  volatile unsigned int t;
 
  
  for (num = 0; num < delay_us; num++)
  {
    t = 11;
    while (t != 0)
    {
      t--;
    }
  }
}


#ifdef __cplusplus
}
#endif

