/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    Test_CpuCRC.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "GS32F00xx.h"
#include "stdio.h"
#include "crc.h"
#include "interrupt.h"
#include "printf.h"
#include "CRC_ex05_dmaread_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

uint32_t CRC_data_in[DMA_BUF_SIZE] = {0x00000011,0x00000022,0x00000033,0x00000044};
uint32_t CRC_data_in_7bit[DMA_BUF_SIZE] = {0x0000005f, 0x0000007f, 0x0000005f, 0x0000007f};
uint32_t CRC_result[5] = {0,0,0,0,0};

uint16_t crcErr = 0;
uint16_t crcRight = 0;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


 /**
 * \brief   Test CPUCRC
 * \param   none
 * \retval  None
 */
uint16_t i=0;
 void Test_dmaCRC(void)
{
    /* Config DMA to trans CRC result to memory */
    DMA_ConfigParams dmaCfg = {0};

    //
    // Enable DMA channel 0 interrupt.
    //
    DMA_initController(DMA_BASE);

    /* Stop DMA channel first - why the DMA channel is still pending after reset? */
    DMA_stopChannel(DMA_CH1_BASE);

    /* DMA Config */
    dmaCfg.enableInterrupt = 0;
    dmaCfg.srcAddr = (uint32_t)CRC_data_in;
    dmaCfg.destAddr = CRC_DR;
    dmaCfg.blockTS = DMA_BUF_SIZE;
    dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);
    delay_us(1000);

    /* Set CRC32bit to calculate */
    /* Configuration */
	CRC_ConfigParams crcConfigParams;
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_32BIT;
	crcConfigParams.polyValue = 0x04C11DB7;
	crcConfigParams.dataSize = 4;
	crcConfigParams.goldenValue = 0xF2074901;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
    CRC_startCalculation(CRC_BASE);
    DMA_startChannel(DMA_CH1_BASE);//
    delay_us(5000);

    /* Check if the result is right */
    CRC_result[0] = CRC_getResult(CRC_BASE);

    if(CRC_result[0] == 0xF2074901){/*32poly 04C11DB7*/
    	crcRight |= 0x01;
        printf("DMA32bitCRC test success\r\n");
    }
    else{
    	crcErr |= 0x01;
        printf("DMA32bitCRC test failed\r\n");
    }

/*******************************************************************/

	/* DMA Config */
    dmaCfg.enableInterrupt = 0;
    dmaCfg.srcAddr = (uint32_t)CRC_data_in;
    dmaCfg.destAddr = CRC_DR;
    dmaCfg.blockTS = DMA_BUF_SIZE;
    dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

    delay_us(1000);
    /* Set CRC24bit to calculate */
    /* Configuration */
   	crcConfigParams.initData = 0x00000000;
   	crcConfigParams.polySize = CRC_POLYSIZE_24BIT;
   	crcConfigParams.polyValue = 0x00864CFB;
   	crcConfigParams.dataSize = 4;
   	crcConfigParams.goldenValue = 0x00C86C58;
   	CRC_initConfig(CRC_BASE, crcConfigParams);
   	/* ENABLE  */
    CRC_startCalculation(CRC_BASE);
    DMA_startChannel(DMA_CH1_BASE);//

    delay_us(1000);
    /* Check if the result is right */
    CRC_result[1] = CRC_getResult(CRC_BASE);

    if(CRC_result[1] == 0xC86C58){ /*24poly 864CFB*/
    	crcRight |= 0x02;
        printf("DMA24bitCRC test success\r\n");
    }
    else{
    	crcErr |= 0x02;
        printf("DMA24bitCRC test failed\r\n");
    }
/*******************************************************************/
	/* DMA Config */
    dmaCfg.enableInterrupt = 0;
    dmaCfg.srcAddr = (uint32_t)CRC_data_in;
    dmaCfg.destAddr = CRC_DR;
    dmaCfg.blockTS = DMA_BUF_SIZE;
    dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

    delay_us(1000);

    /* Set CRC16bit to calculate */
	/* Configuration */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_16BIT;
	crcConfigParams.polyValue = 0x00008005;
	crcConfigParams.dataSize = 4;
	crcConfigParams.goldenValue = 0x00001D84;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
    CRC_startCalculation(CRC_BASE);
    DMA_startChannel(DMA_CH1_BASE);//
    delay_us(1000);
    /* Check if the result is right */
    CRC_result[2] = CRC_getResult(CRC_BASE);

    if(CRC_result[2] == 0x1D84){ /*16poly 8005*/
    	crcRight |= 0x04;
        printf("DMA16bitCRC test success\r\n");
    }
    else{
    	crcErr |= 0x04;
        printf("DMA16bitCRC test failed\r\n");
    }
/*******************************************************************/

	/* DMA Config */
    dmaCfg.enableInterrupt = 0;
    dmaCfg.srcAddr = (uint32_t)CRC_data_in;
    dmaCfg.destAddr = CRC_DR;
    dmaCfg.blockTS = DMA_BUF_SIZE;
    dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

    /* Set CRC8bit to calculate */
	/* Configuration */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_8BIT;
	crcConfigParams.polyValue = 0x00000007;
	crcConfigParams.dataSize = 4;
	crcConfigParams.goldenValue = 0x000000F9;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
    CRC_startCalculation(CRC_BASE);
    DMA_startChannel(DMA_CH1_BASE);//

    delay_us(1000);

    /* Check if the result is right */
    CRC_result[3] = CRC_getResult(CRC_BASE);
    if(CRC_result[3] == 0xF9){ /*8poly 07*/
    	crcRight |= 0x08;
        printf("DMA8bitCRC test success\r\n");
    }
    else{
    	crcErr |= 0x08;
        printf("DMA8bitCRC test failed\r\n");
    }
/*******************************************************************/
    DMA_initController(DMA_BASE);
	/* XDMA Config */
    dmaCfg.enableInterrupt = 0;
    dmaCfg.srcAddr = (uint32_t)CRC_data_in;
    dmaCfg.destAddr = CRC_DR;
    dmaCfg.blockTS = DMA_BUF_SIZE;
    dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

    /* Set CRC8bit to calculate */
	/* Configuration */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_7BIT;
	crcConfigParams.polyValue = 0x00000009;
	crcConfigParams.dataSize = 4;
	crcConfigParams.goldenValue = 0x0000004B;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
    CRC_startCalculation(CRC_BASE);
    DMA_startChannel(DMA_CH1_BASE);
    delay_us(1000);

    /* Check if the result is right */
    CRC_result[4] = CRC_getResult(CRC_BASE);
    if(CRC_result[4] == 0x4B){ /*7poly 09*/
    	crcRight |= 0x10;
        printf("DMA7bitCRC test success\r\n");
    }
    else{
    	crcErr |= 0x10;
        printf("DMA7bitCRC test failed\r\n");
    }
/*******************************************************************/


}

void delay_us(uint32_t delay_us)
{
  volatile unsigned int num;
  volatile unsigned int t;


  for (num = 0; num < delay_us; num++)
  {
    t = 11;
    while (t != 0)
    {
      t--;
    }
  }
}

#ifdef __cplusplus
}
#endif

