/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    dma_ex02_adc_meas_16chns_cvert2tfr_board.h
*   @brief   
*
*/

#ifndef DMA_EX02_ADC_MEAS_4CHNS_CVERT2TFR_BOARD_H_
#define DMA_EX02_ADC_MEAS_4CHNS_CVERT2TFR_BOARD_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//
// Defines for debug UART
//
#if __arm__
#define SCI_BASE 		(SCIB_BASE)
#else
#define SCI_BASE 		(SCIA_BASE)
#endif

//
// Defines for DMA
//
#define DMA_CH_TRIGGER     DMAMUX_ReqId_Trig_ADCA_4int
#define DMA_TFR_SIZE       (16U)

//
// Defines for ADC
//
#define testADC_BASE        ADCA_BASE
#define testADC_INT_NUMBER  ADC_INT_NUMBER4
#define testADC_TRIGGER     ADC_TRIGGER_EPWM1_SOCA
#define testADC_SAMPLEWINDOW    (60U)
//
// Defines for PWM
//
#define  cFreq_1000K_200M   (200U)
#define  cFreq_100K_200M    (2000U)
#define  cFreq_50K_200M     (4000U)
#define  cFreq_25K_200M     (8000U)
#define  cFreq_10K_200M     (20000U)
#define  cFreq_1000K_400M    (400U)
#define  cFreq_100K_400M    (4000U)
#define  cFreq_50K_400M     (8000U)
#define  cFreq_25K_400M     (16000U)
#define  cFreq_10K_400M     (40000U)
#define  cFreq_100K_360M    (3600U)
#define  cFreq_50K_360M     (7200U)
#define  cFreq_25K_360M     (14400U)
#define  cFreq_10K_360M     (36000U)

#define  c300ns_400M        (120U)        // 300/2.5ns = 120
#define  c300ns_360M        (1080U)       // 300/2.78ns = 108
#define  c300ns_200M        (60U)        // 300/5ns = 60
#define  cPwmPeriod         cFreq_10K_360M  //10ms
#define  cPwmIntEvtCnt      (1U)
#define  cDB_RED_SET        0U // c300ns_200M  
#define  cDB_FED_SET        0U // c300ns_200M 

#define testPWM_BASE        EPWM1_BASE
#define testPWM_INT         INT_EPWM1


//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************
//
// EPWM1 -> myEPWM1 Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 0
#define myEPWM1_EPWMA_GPIO 0
#define myEPWM1_EPWMA_PIN_CONFIG GPIO_0_EPWM1_A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 1
#define myEPWM1_EPWMB_GPIO 1
#define myEPWM1_EPWMB_PIN_CONFIG GPIO_1_EPWM1_B


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

typedef struct {
    Uint32 dlog_load_start;
    Uint32 dlog_load_stop;
    Uint32 dlog_loads;
    Uint32 dlog_load_max;
    Uint32 dlog_load_cnt;
    Uint32 dlog_load_aver;
}DLOG_LOAD_COMP;

typedef struct {
__IO DLOG_LOAD_COMP    adc_cvt;
__IO DLOG_LOAD_COMP    adc_dmatfr;
}DLOAD_STRUCT;


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */


/**
 * \brief   "get flash cache Statistic Hit"
 *
 * \param   cacheBase is the base address of the flash cache registers.
 *
 * \retval  Counts the number of cache hits during cache look up.
 */
CCMFUNC_T static inline Uint32 cFlash_Cache_getStatisticHit(Uint32 cacheBase)
{
    //
    // Check the arguments.
    //
    ASSERT(Flash_isCacheBaseValid(cacheBase));

    return HWREG(cacheBase + FLASH_CACHE_O_CSHR);
}

CCMFUNC_T static inline void cFlash_Cache_clearStatisticHit(Uint32 cacheBase)
{
    //
    // Check the arguments.
    //
    ASSERT(Flash_isCacheBaseValid(cacheBase));

    HWREG(cacheBase + FLASH_CACHE_O_CSHR) = 0;
}

/**
 * \brief   "get flash cache Statistic Miss"
 *
 * \param   cacheBase is the base address of the flash cache registers.
 *
 * \retval  Counts the number of cache hits during cache look up.
 */
CCMFUNC_T static inline Uint32 cFlash_Cache_getStatisticMiss(Uint32 cacheBase)
{
    //
    // Check the arguments.
    //
    ASSERT(Flash_isCacheBaseValid(cacheBase));

    return HWREG(cacheBase + FLASH_CACHE_O_CSMR);
}

CCMFUNC_T static inline void cFlash_Cache_clearStatisticMiss(Uint32 cacheBase)
{
    //
    // Check the arguments.
    //
    ASSERT(Flash_isCacheBaseValid(cacheBase));

    HWREG(cacheBase + FLASH_CACHE_O_CSMR) = 0;
}

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void Board_init();
void PinMux_init();
void sAdc_config(Uint32 adcBase, ADC_Trigger trigger, ADC_IntNumber adcIntNum, uint32_t sampleWindow);
void setupUpCountPWM(Uint32 base, Uint16 pwm_period_ticks,Uint16 Deadtime_RED,Uint16 Deadtime_FED,Uint16 phaseCount);
void configureEPWM(Uint32 epwmBase);
void DMA_CHN_Modeconfig(void);

#ifdef __cplusplus
}
#endif


#endif /* DMA_EX02_ADC_MEAS_4CHNS_CVERT2TFR_BOARD_H_ */
