/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    dma_ex02_adc_meas_16chns_cvert2tfr_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "dma_ex02_adc_meas_16chns_cvert2tfr_board.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

__IO Uint16 testADC0DataBuffer[4];

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
    EALLOW;    
    PinMux_init();
 
    sAdc_config(testADC_BASE, 
                testADC_TRIGGER, 
                testADC_INT_NUMBER,
                testADC_SAMPLEWINDOW);
    EDIS;
}


// PINMUX Configurations
void PinMux_init()
{
    //
    // EPWM1 -> myEPWM1 Pinmux
    //
    GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);
}

void sAdc_config(Uint32 adcBase, ADC_Trigger trigger, ADC_IntNumber adcIntNum, uint32_t sampleWindow)
{
    //
    // ADC Initialization: Write ADC configurations and power up the ADC
    //
    // Configures the ADC module's offset trim
    //
#if ((GS32F3xx & 0xFF00) || (GS32F00xx & 0xFF00))
    ADC_setVREF(adcBase,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);
#endif
    ADC_setINLTrim(adcBase);
    //
    // Configures the analog-to-digital converter module prescaler.
    //
    ADC_setPrescaler(adcBase, ADC_CLK_DIV_4_0);
    //
    // Sets the timing of the end-of-conversion pulse
    //
    ADC_setInterruptPulseMode(adcBase, ADC_PULSE_END_OF_CONV);
    //
    // Powers up the analog-to-digital converter core.
    //
    ADC_enableConverter(adcBase);
    //
    // Delay for 1ms to allow ADC time to power up
    //
    DEVICE_DELAY_US(5000);

    //
    // SOC Configuration: Setup ADC EPWM channel and trigger settings
    //
    // Disables SOC burst mode.
    //
    ADC_disableBurstMode(adcBase);
    //
    // Sets the priority mode of the SOCs.
    //
    ADC_setSOCPriority(adcBase, ADC_PRI_ALL_ROUND_ROBIN);
    //
    // Start of Conversion 0 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 0
    //          Trigger            : ADC_TRIGGER_EPWM2_SOCA
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER0, trigger, ADC_CH_ADCIN0, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER0, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 1 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 1
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER1, trigger, ADC_CH_ADCIN1, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER1, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 2 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 2
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER2, trigger, ADC_CH_ADCIN2, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER2, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 3 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 3
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER3, trigger, ADC_CH_ADCIN3, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER3, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 4 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 4
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER4, trigger, ADC_CH_ADCIN4, 50U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER4, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 5 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 5
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER5, trigger, ADC_CH_ADCIN5, 50U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER5, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 6 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 6
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER6, trigger, ADC_CH_ADCIN6, 50U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER6, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 7 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 7
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER7, trigger, ADC_CH_ADCIN7, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER7, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 8 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 8
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER8, trigger, ADC_CH_ADCIN8, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER8, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 9 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 9
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER9, trigger, ADC_CH_ADCIN9, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER9, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 10 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 10
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER10, trigger, ADC_CH_ADCIN10, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER10, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 11 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 11
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER11, trigger, ADC_CH_ADCIN11, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER11, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 12 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 12
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER12, trigger, ADC_CH_ADCIN12, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER12, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 13 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 13
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER13, trigger, ADC_CH_ADCIN13, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER13, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 14 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 14
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER14, trigger, ADC_CH_ADCIN14, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER14, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // Start of Conversion 15 Configuration
    //
    //
    // Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
    //           SOC number        : 15
    //          Trigger            : ADC_TRIGGER_SW_ONLY
    //          Channel            : ADC_CH_ADCIN3
    //         Sample Window    : 9 SYSCLK cycles
    //        Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
    //
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER15, trigger, ADC_CH_ADCIN15, sampleWindow);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER15, ADC_INT_SOC_TRIGGER_ADCINT1);
    //
    // ADC Interrupt 1 Configuration
    //         SOC/EOC number    : 0
    //         Interrupt Source: enabled
    //        Continuous Mode    : enabled
    //
    ADC_setInterruptSource(adcBase, adcIntNum, ADC_SOC_NUMBER15);
    ADC_enableInterrupt(adcBase, adcIntNum);
    ADC_clearInterruptStatus(adcBase, adcIntNum);
    ADC_enableContinuousMode(adcBase, adcIntNum);
}

void setupUpCountPWM(Uint32 base, Uint16 pwm_period_ticks,Uint16 Deadtime_RED,Uint16 Deadtime_FED,Uint16 phaseCount)
{
    //
    // Time Base SubModule Registers
    //
    EPWM_setPeriodLoadMode(base, EPWM_PERIOD_SHADOW_LOAD);
    EPWM_setTimeBasePeriod(base, pwm_period_ticks - 1);    
    HRPWM_setTimeBaseCounter(base, 0);
    //if(base == EPWM7_BASE)
    //{
        EPWM_enableSyncOutPulseSource(base, EPWM_SYNC_OUT_PULSE_ON_CNTR_ZERO);
    //}
    //else
    //{
    //    EPWM_enableSyncOutPulseSource(base, EPWM_SYNC_OUT_PULSE_ON_SOFTWARE);
    //}
    HRPWM_setPhaseShift(base, phaseCount);
    HRPWM_enablePhaseShiftLoad(base);


    EPWM_setTimeBaseCounterMode(base, EPWM_COUNTER_MODE_UP);
    //EPWM_setTimeBaseCounterMode(base1, EPWM_COUNTER_MODE_UP_DOWN);

    HRPWM_setClockPrescaler(base, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);

    //EPWM_setSyncInPulseSource(base1,source);

    //
    // Counter Compare Submodule Registers
    // set duty 0% initially
    //
    EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, 0);  
    HRPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_A,
                                         EPWM_COMP_LOAD_ON_CNTR_ZERO);
  

    HWREGH(base + HRPWM_O_AQCTLA) = 0U;
    HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A ,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A ,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

    //
    // DeadTimer
    //
    EPWM_setDeadBandCounterClock(base,EPWM_DB_COUNTER_CLOCK_HALF_CYCLE);
    EPWM_setRisingEdgeDeadBandDelayInput(base,EPWM_DB_INPUT_EPWMA);
    EPWM_setFallingEdgeDeadBandDelayInput(base,EPWM_DB_INPUT_EPWMA);
    EPWM_setDeadBandDelayPolarity(base,EPWM_DB_RED,EPWM_DB_POLARITY_ACTIVE_HIGH);
    EPWM_setDeadBandDelayPolarity(base,EPWM_DB_FED,EPWM_DB_POLARITY_ACTIVE_LOW);
    EPWM_setDeadBandDelayMode(base,EPWM_DB_RED,TRUE);
    EPWM_setDeadBandDelayMode(base,EPWM_DB_FED,TRUE);
    EPWM_setDeadBandOutputSwapMode(base,EPWM_DB_OUTPUT_A,FALSE);
    EPWM_setDeadBandOutputSwapMode(base,EPWM_DB_OUTPUT_B,FALSE);
    EPWM_setRisingEdgeDelayCount(base,Deadtime_RED);
    EPWM_setFallingEdgeDelayCount(base,Deadtime_FED);

#if (defined (ENABLE_TZ) && ENABLE_TZ)
    //TZ
    EPWM_enableTripZoneSignals(base,EPWM_TZ_SIGNAL_OSHT1);
    EPWM_setTripZoneAction(base, EPWM_TZ_ACTION_EVENT_TZA,
                   EPWM_TZ_ACTION_LOW);
    EPWM_setTripZoneAction(base, EPWM_TZ_ACTION_EVENT_TZB,
                   EPWM_TZ_ACTION_LOW);

    EPWM_forceTripZoneEvent(base,EPWM_TZ_FORCE_EVENT_OST);
#endif

    //HR

    HRPWM_setCounterCompareShadowLoadEvent(base, HRPWM_CHANNEL_A, HRPWM_LOAD_ON_CNTR_ZERO);
    HRPWM_setMEPControlMode(base,HRPWM_CHANNEL_A,HRPWM_MEP_DUTY_PERIOD_CTRL);
    HRPWM_setMEPEdgeSelect(base,HRPWM_CHANNEL_A,HRPWM_MEP_CTRL_FALLING_EDGE);

    //    HRPWM_setDeadbandMEPEdgeSelect(base, HRPWM_DB_MEP_CTRL_FED);
    //    HRPWM_setFallingEdgeDelayLoadMode(base, HRPWM_LOAD_ON_CNTR_ZERO);

    HRPWM_setMEPEdgeSelect(base,HRPWM_CHANNEL_B,HRPWM_MEP_CTRL_RISING_EDGE);
    HRPWM_setMEPControlMode(base,HRPWM_CHANNEL_B,HRPWM_MEP_DUTY_PERIOD_CTRL);
    HRPWM_setCounterCompareShadowLoadEvent(base, HRPWM_CHANNEL_B, HRPWM_LOAD_ON_CNTR_ZERO);
}


void configureEPWM(Uint32 epwmBase)
{
#if ENABLE_HRPWM
    EPWM_setHrpwmDllCfg0(PREEPWM_BASE,0x81F1CB83);
    EPWM_setHrpwmDllCfg1(PREEPWM_BASE,0x703);
    EPWM_setEpwmtopHrpwmBypass(PREEPWM_BASE,0);
#endif 

    setupUpCountPWM(epwmBase, cPwmPeriod, cDB_RED_SET,cDB_FED_SET,0);


    EPWM_clearEventTriggerInterruptFlag(epwmBase);

    EPWM_setInterruptSource(epwmBase, EPWM_INT_TBCTR_PERIOD);// phase 0
    EPWM_enableInterrupt(epwmBase);
    EPWM_enableADCTrigger(epwmBase, EPWM_SOC_A);
    EPWM_setADCTriggerSource(epwmBase, EPWM_SOC_A, EPWM_SOC_TBCTR_ZERO);
    EPWM_setADCTriggerEventPrescale(epwmBase, EPWM_SOC_A, 1U);
    EPWM_setInterruptEventCount(epwmBase, cPwmIntEvtCnt);

    //
    // Enable initialization of the SOCA event counter. Since we are
    // disabling the ETSEL.SOCAEN bit, we need a way to reset the SOCACNT.
    // Hence, enable the counter initialize control.
    //
    EPWM_enableADCTriggerEventCountInit(epwmBase, EPWM_SOC_A);
}

//
// configureDMAChannels - Initialize DMA ch 0 to transfer ADC results
//                        
//
void DMA_CHN_Modeconfig(void)
{
    DMA_ConfigParams dma1Cfg = {0};

    dma1Cfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    dma1Cfg.dmaSrcReqId = DMA_CH_TRIGGER;
    dma1Cfg.srcAddr = (Uint32)(&AdcaResultRegs.ADCRESULT0);
    dma1Cfg.destAddr = (Uint32)(&testADC0DataBuffer[0]);
    dma1Cfg.blockTS = DMA_TFR_SIZE;
    dma1Cfg.reloadSrc = TRUE;
    dma1Cfg.reloadDst = TRUE;
    dma1Cfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
    dma1Cfg.srcBtl  = DMA_BTL_16;
    dma1Cfg.destBtl = DMA_BTL_16;
    dma1Cfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
    dma1Cfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_2;
    dma1Cfg.srcAddrDirect = DMA_ADDR_INCRE;
    dma1Cfg.destAddrDirect = DMA_ADDR_INCRE;
    dma1Cfg.chPriority = DMA_CH_PRIORITY_0;
    
    DMA_configChannel(DMA_CH1_BASE, &dma1Cfg);
    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_BLOCK);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_BLOCK);
}


#ifdef __cplusplus
}
#endif

