/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap_ex02_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "ecap_ex02_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

// Board Configurations
void  Board_init()
{
	PinMux_init();
    ECAP_init();
	OUTPUTXBAR_init();
}

// PINMUX Configurations
void PinMux_init()
{
	GPIO_setPinConfig(GPIO_26_OUTPUTXBAR3);
	GPIO_setPadConfig(26, GPIO_PIN_TYPE_STD);


	GPIO_setPinConfig(GPIO_27_OUTPUTXBAR4);
	GPIO_setPadConfig(27, GPIO_PIN_TYPE_STD);


}

// ECAP Configurations
void ECAP_init()
{
    myECAP0_init();
	myECAP1_init();
}

// ECAP Configurations for the module ECAP1
void myECAP0_init()
{
  // Stops Time stamp counter.
	
	ECAP_stopCounter(myECAP0_BASE);
    
	// Sets eCAP in APWM mode.
	
	ECAP_enableAPWMMode(myECAP0_BASE);
	
	// Set eCAP APWM period.
	
	ECAP_setAPWMPeriod(myECAP0_BASE,2000U);
	
	// Set eCAP APWM on or off time count.
	
	ECAP_setAPWMCompare(myECAP0_BASE,1000U);
	
	// Set eCAP APWM polarity.
	
	ECAP_setAPWMPolarity(myECAP0_BASE,ECAP_APWM_ACTIVE_LOW);
	
	// Sets a phase shift value count.
	
	ECAP_setPhaseShiftCount(myECAP0_BASE,0U);
	
	// Disable counter loading with phase shift value.
	
	ECAP_disableLoadCounter(myECAP0_BASE);
	
	// Configures Sync out signal mode.
	
	ECAP_setSyncOutMode(myECAP0_BASE,ECAP_SYNC_OUT_COUNTER_PRD);
	
	// Configures emulation mode.
	
	ECAP_setEmulationMode(myECAP0_BASE,ECAP_EMULATION_STOP);
	
	// Starts Time stamp counter for myECAP0.
	
	//ECAP_startCounter(myECAP0_BASE);
}

// ECAP Configurations for the module ECAP2
void myECAP1_init()
{
    // Stops Time stamp counter.
	
	ECAP_stopCounter(myECAP1_BASE);
    
	// Sets eCAP in APWM mode.
	
	ECAP_enableAPWMMode(myECAP1_BASE);
	
	// Set eCAP APWM period.
	
	ECAP_setAPWMPeriod(myECAP1_BASE,2000U);
	
	// Set eCAP APWM on or off time count.
	
	ECAP_setAPWMCompare(myECAP1_BASE,1000U);
	
	// Set eCAP APWM polarity.
	
	ECAP_setAPWMPolarity(myECAP1_BASE,ECAP_APWM_ACTIVE_LOW);
	
	// Sets a phase shift value count.
	
	ECAP_setPhaseShiftCount(myECAP1_BASE,500U);
	
	// Enable counter loading with phase shift value.
	
	ECAP_enableLoadCounter(myECAP1_BASE);
	
	// Configures Sync out signal mode.
	
	ECAP_setSyncOutMode(myECAP1_BASE,ECAP_SYNC_OUT_SYNCI);
	
	// Configures emulation mode.
	
	ECAP_setEmulationMode(myECAP1_BASE,ECAP_EMULATION_STOP);
	
	// Set up the source for sync-in pulse..
	
	ECAP_setSyncInPulseSource(myECAP1_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP1);
	
	// Starts Time stamp counter for myECAP0.
	
	ECAP_startCounter(myECAP1_BASE);
	ECAP_startCounter(myECAP0_BASE);
}

// OUTPUTXBAR Configurations
void OUTPUTXBAR_init(){
	myOUTPUTXBAR0_init();
	myOUTPUTXBAR1_init();
}

// OUTPUTXBAR Configurations for ECAP1
void myOUTPUTXBAR0_init(){
	XBAR_setOutputLatchMode(OUTPUTXBAR_BASE,myOUTPUTXBAR0, false);
	XBAR_invertOutputSignal(OUTPUTXBAR_BASE,myOUTPUTXBAR0, false);
		
	//
	//Mux configuration
	//
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,myOUTPUTXBAR0, XBAR_OUT_MUX00_ECAP1_OUT);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE,myOUTPUTXBAR0, myOUTPUTXBAR0_ENABLED_MUXES);
}

// OUTPUTXBAR Configurations for ECAP2
void myOUTPUTXBAR1_init(){
	XBAR_setOutputLatchMode(OUTPUTXBAR_BASE,myOUTPUTXBAR1, false);
	XBAR_invertOutputSignal(OUTPUTXBAR_BASE,myOUTPUTXBAR1, false);
		
	//
	//Mux configuration
	//
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,myOUTPUTXBAR1, XBAR_OUT_MUX02_ECAP2_OUT);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE,myOUTPUTXBAR1, myOUTPUTXBAR1_ENABLED_MUXES);
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/* None */

/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif

