/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap_ex08_capture_three_phase_pwm.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "ecap_ex08_capture_three_phase_pwm.h"
#include "printf.h"
#include "stdlib.h"
#include "ecap_ex08_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

uint32_t myEPWM1_DIR;
uint32_t myEPWM2_DIR;
uint32_t myEPWM3_DIR;
vuint32_t pwm1_cmpaAVal;
vuint32_t pwm2_cmpaAVal;
vuint32_t pwm3_cmpaAVal;
vuint32_t pwm1_cmpaBVal;
vuint32_t pwm2_cmpaBVal;
vuint32_t pwm3_cmpaBVal;
uint32_t max_Size = 512;
vuint32_t INTRs = 0;

float Arr1[256] = {0};
float Arr2[256] = {0};
float Arr3[256] = {0};
float Arr4[256] = {0};
float Arr5[256] = {0};
float Arr6[256] = {0};
uint32_t size1;
uint32_t size2;
uint32_t size3;
uint32_t size4;
uint32_t size5;
uint32_t size6;

float duty;
uint32_t ecapLow;
uint32_t ecapHigh;

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

void myEPWM0_init(void);
void EPWM_init(void);
void SYNC_init(void);

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */


void addToStaticArray(float *arr, uint32_t size, float value) {
    if (size >= 256) {
        size %= 256;
    }
    arr[size] = value;
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void main(void){

	Device_init();
	__enable_irq();
	myEPWM1_DIR = EPWM_TIMER_UP;
	myEPWM2_DIR = EPWM_TIMER_UP;
	myEPWM3_DIR = EPWM_TIMER_UP;
	size1 = 0;
	size2 = 0;
	size3 = 0;
	size4 = 0;
	size5 = 0;
	size6 = 0;

	// Board initialization
    //
	Board_init();

	EPWM_init();
	SYNC_init();

    // Loop forever. Suspend or place breakpoints to observe the buffers.
    while(1)
    {

    }
}

// EPWM Configurations
void EPWM_init()
{
	myEPWM0_init();
}

// EPWM Configurations for EPWM1~6
void myEPWM0_init()
{
	  EPWM_setClockPrescaler(myEPWM1_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	    EPWM_setTimeBasePeriod(myEPWM1_BASE, 2000);
	    EPWM_setTimeBaseCounter(myEPWM1_BASE, 0);
	    EPWM_setTimeBaseCounterMode(myEPWM1_BASE, EPWM_COUNTER_MODE_UP);
	    EPWM_disablePhaseShiftLoad(myEPWM1_BASE);
	    EPWM_setPhaseShift(myEPWM1_BASE, 0);
	    EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, 6);
	    EPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	    EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, 667);
	    EPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_TOGGLE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
	    EPWM_enableInterrupt(myEPWM1_BASE);
	    EPWM_setInterruptSource(myEPWM1_BASE, EPWM_INT_TBCTR_ZERO);
	    EPWM_setInterruptEventCount(myEPWM1_BASE, 3);
	    EPWM_setClockPrescaler(myEPWM2_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	    EPWM_setTimeBasePeriod(myEPWM2_BASE, 2000);
	    EPWM_setTimeBaseCounter(myEPWM2_BASE, 0);
	    EPWM_setTimeBaseCounterMode(myEPWM2_BASE, EPWM_COUNTER_MODE_UP);
	    EPWM_enablePhaseShiftLoad(myEPWM2_BASE);
	    EPWM_setPhaseShift(myEPWM2_BASE, 0);
	    EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, 1333);
	    EPWM_setCounterCompareShadowLoadMode(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	    EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, 667);
	    EPWM_setCounterCompareShadowLoadMode(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_TOGGLE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);

	    SysCtl_enablePeripheral_TBCLKSYNC();
	        EPWM_setHrpwmDllCfg0(PREEPWM_BASE,0x1);
}
void SYNC_init(void)
{
	// treat ecap sync-out as sync-source
	ECAP_stopCounter(SYNC_BASE);

	ECAP_enableAPWMMode(SYNC_BASE);

	ECAP_setAPWMPeriod(SYNC_BASE,9000U);

	ECAP_setAPWMCompare(SYNC_BASE,4500U);

	ECAP_setAPWMPolarity(SYNC_BASE,ECAP_APWM_ACTIVE_LOW);

	ECAP_setPhaseShiftCount(SYNC_BASE,0U);

	ECAP_enableLoadCounter(SYNC_BASE);

	ECAP_setSyncOutMode(SYNC_BASE,ECAP_SYNC_OUT_SYNCI);

	ECAP_setEmulationMode(SYNC_BASE,ECAP_EMULATION_STOP);

	ECAP_setSyncInPulseSource(SYNC_BASE,ECAP_SYNC_IN_PULSE_SRC_DISABLE);

	ECAP_startCounter(SYNC_BASE);

	ECAP_loadCounter(SYNC_BASE);
}

void Ecap_ex08_IrqHandler1(void)
{
	++INTRs;

	// duty record
	if ((ECAP_getInterruptSource(myECAP1_BASE) & ECAP_ISR_SOURCE_CAPTURE_EVENT_3))
	{
		ecapHigh = ECAP_getEventTimeStamp(myECAP1_BASE,ECAP_EVENT_2);
		ecapLow = ECAP_getEventTimeStamp(myECAP1_BASE,ECAP_EVENT_3);
		duty = (float)ecapHigh/(ecapHigh+ecapLow);
		addToStaticArray(Arr1,size1++,duty);
		ECAP_clearInterrupt(myECAP1_BASE,0xFEU);
		ECAP_clearGlobalInterrupt(myECAP1_BASE);
		ECAP_reArm(myECAP1_BASE);
	}
	if ((ECAP_getInterruptSource(myECAP2_BASE) & ECAP_ISR_SOURCE_CAPTURE_EVENT_3))
	{
		ecapHigh = ECAP_getEventTimeStamp(myECAP2_BASE,ECAP_EVENT_2);
		ecapLow = ECAP_getEventTimeStamp(myECAP2_BASE,ECAP_EVENT_3);
		duty = (float)ecapHigh/(ecapHigh+ecapLow);
		addToStaticArray(Arr2,size2++,duty);
		ECAP_clearInterrupt(myECAP2_BASE,0xFEU);
		ECAP_clearGlobalInterrupt(myECAP2_BASE);
		ECAP_reArm(myECAP2_BASE);
	}

	// epwm1
	pwm1_cmpaAVal = EPWM_getCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A);
	pwm1_cmpaBVal = EPWM_getCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B);
	if (pwm1_cmpaAVal >= PWM_CMP_MAX)
	{
		myEPWM1_DIR = EPWM_TIMER_DOWN;
	}
	else if (pwm1_cmpaAVal <= PWM_CMP_MIN)
	{
		myEPWM1_DIR = EPWM_TIMER_UP;
	}
	if (myEPWM1_DIR == EPWM_TIMER_DOWN)
	{
		EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, pwm1_cmpaAVal-100U);
		EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, pwm1_cmpaBVal-100U);
	}
	else if (myEPWM1_DIR == EPWM_TIMER_UP)
	{
		EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, pwm1_cmpaAVal+100U);
		EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, pwm1_cmpaBVal+100U);
	}

	EPWM_clearEventTriggerInterruptFlag(myEPWM1_BASE);
}

void Ecap_ex08_IrqHandler2(void)
{
	++INTRs;
	// duty record
	if ((ECAP_getInterruptSource(myECAP3_BASE) & ECAP_ISR_SOURCE_CAPTURE_EVENT_3))
	{
		ecapHigh = ECAP_getEventTimeStamp(myECAP3_BASE,ECAP_EVENT_2);
		ecapLow = ECAP_getEventTimeStamp(myECAP3_BASE,ECAP_EVENT_3);
		duty = (float)ecapHigh/(ecapHigh+ecapLow);
		addToStaticArray(Arr3,size3++,duty);
		ECAP_clearInterrupt(myECAP3_BASE,0xFEU);
		ECAP_clearGlobalInterrupt(myECAP3_BASE);
		ECAP_reArm(myECAP3_BASE);
	}
	if ((ECAP_getInterruptSource(myECAP4_BASE) & ECAP_ISR_SOURCE_CAPTURE_EVENT_3))
	{
		ecapHigh = ECAP_getEventTimeStamp(myECAP4_BASE,ECAP_EVENT_2);
		ecapLow = ECAP_getEventTimeStamp(myECAP4_BASE,ECAP_EVENT_3);
		duty = (float)ecapHigh/(ecapHigh+ecapLow);
		addToStaticArray(Arr4,size4++,duty);
		ECAP_clearInterrupt(myECAP4_BASE,0xFEU);
		ECAP_clearGlobalInterrupt(myECAP4_BASE);
		ECAP_reArm(myECAP4_BASE);
	}

	// epwm2
	pwm2_cmpaAVal = EPWM_getCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A);
	pwm2_cmpaBVal = EPWM_getCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B);
	if (pwm2_cmpaAVal >= PWM_CMP_MAX)
	{
		myEPWM2_DIR = EPWM_TIMER_DOWN;
	}
	else if (pwm2_cmpaAVal <= PWM_CMP_MIN)
	{
		myEPWM2_DIR = EPWM_TIMER_UP;
	}
	if (myEPWM2_DIR == EPWM_TIMER_DOWN)
	{
		EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, pwm2_cmpaAVal-100U);
		EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, pwm2_cmpaBVal-100U);
	}
	else if (myEPWM2_DIR == EPWM_TIMER_UP)
	{
		EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, pwm2_cmpaAVal+100U);
		EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, pwm2_cmpaBVal+100U);
	}

	EPWM_clearEventTriggerInterruptFlag(myEPWM2_BASE);
}

void Ecap_ex08_IrqHandler3(void)
{
	++INTRs;
	// duty record
	if ((ECAP_getInterruptSource(myECAP5_BASE) & ECAP_ISR_SOURCE_CAPTURE_EVENT_3))
	{
		ecapHigh = ECAP_getEventTimeStamp(myECAP5_BASE,ECAP_EVENT_2);
		ecapLow = ECAP_getEventTimeStamp(myECAP5_BASE,ECAP_EVENT_3);
		duty = (float)ecapHigh/(ecapHigh+ecapLow);
		addToStaticArray(Arr5,size5++,duty);
		ECAP_clearInterrupt(myECAP5_BASE,0xFEU);
		ECAP_clearGlobalInterrupt(myECAP5_BASE);
		ECAP_reArm(myECAP5_BASE);
	}
	if ((ECAP_getInterruptSource(myECAP6_BASE) & ECAP_ISR_SOURCE_CAPTURE_EVENT_3))
	{
		ecapHigh = ECAP_getEventTimeStamp(myECAP6_BASE,ECAP_EVENT_2);
		ecapLow = ECAP_getEventTimeStamp(myECAP6_BASE,ECAP_EVENT_3);
		duty = (float)ecapHigh/(ecapHigh+ecapLow);
		addToStaticArray(Arr6,size6++,duty);
		ECAP_clearInterrupt(myECAP6_BASE,0xFEU);
		ECAP_clearGlobalInterrupt(myECAP6_BASE);
		ECAP_reArm(myECAP6_BASE);
	}

	// epwm3
	pwm3_cmpaAVal = EPWM_getCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_A);
	pwm3_cmpaBVal = EPWM_getCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_B);
	if (pwm3_cmpaAVal >= PWM_CMP_MAX)
	{
		myEPWM3_DIR = EPWM_TIMER_DOWN;
	}
	else if (pwm3_cmpaAVal <= PWM_CMP_MIN)
	{
		myEPWM3_DIR = EPWM_TIMER_UP;
	}

	if (myEPWM3_DIR == EPWM_TIMER_DOWN)
	{
		EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_A, pwm3_cmpaAVal-100U);
		EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_B, pwm3_cmpaBVal-100U);
	}
	else if (myEPWM3_DIR == EPWM_TIMER_UP)
	{
		EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_A, pwm3_cmpaAVal+100U);
		EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_B, pwm3_cmpaBVal+100U);
	}

	EPWM_clearEventTriggerInterruptFlag(myEPWM3_BASE);
}

#ifdef __cplusplus
}
#endif
