/*
 *   Copyright (c) Gejian Semiconductors 2024
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* Includes ------------------------------------------------------------------*/
#include <sys/stat.h>

#include "device.h"
#include "board_cfg.h"
#include "flash_programming_gs32.h"
#include "gs32_flashAPI_lib.h"
#include "board_cfg.h"

#define TEST_SECTOR_ADDR Bzero_Sector66_start

#define BUFF_NODE_COUNT 100
uint32 buff[BUFF_NODE_COUNT] = {0};

#define RDP0_VALUE 0xaa
#define RDP1_VALUE 0xbb
#define RDP2_VALUE 0xcc

int main(void)
{
	volatile uint32 ret = 0;
	volatile uint32 index = 0;
	volatile uint32 *p = 0x1fff4060;

	Device_init();
	if ( 0 != *p )
	{
		ret = GS32Fapi_Init(DEVICE_SYSCLK_FREQ);
		if ( 0 != ret )
		{
			goto while_loop;
		}
		ret = GS32Fapi_EraseSector(TEST_SECTOR_ADDR);
		if ( 0 != ret )
		{
			goto while_loop;
		}

		memcpy((void *)buff,(void *)TEST_SECTOR_ADDR,BUFF_NODE_COUNT*sizeof(uint32));
		buff[24] =0x00000000;

		ret = GS32Fapi_Program(TEST_SECTOR_ADDR, (uint32 )buff, BUFF_NODE_COUNT);
		if ( 0 != ret )
		{
			goto while_loop;
		}
	}
	GS32Fapi_OPT_SetRDP(RDP2_VALUE);
while_loop:
	for(;;);
	return 0;
}

/*****END OF FILE****/
