/*
 * sci_drv.c
 *
 *  Created on: 2025 Apr 21
 *      Author: s026h
 */

#include "device.h"
#include "sci_bsp.h"
#include "OS.h"
#include "string.h"

SCI_TxMsgCfg_t SCI_TxMsg;
SCI_RxMsgCfg_t SCI_RxMsg;


uint8_t myRxBuf[32];

void sci_init(uint32_t sci_base)
{
	//uint32_t sci_base = SCIA_BASE;
	SCI_reset(sci_base);
	SCI_setConfig(sci_base, DEVICE_AHBCLK_FREQ, 115200, SCI_CONFIG_PAR_NONE | SCI_CONFIG_STOP_ONE | SCI_CONFIG_WLEN_8);
	SCI_enableFIFO(sci_base);
	SCI_setFIFOInterruptLevel(sci_base, SCI_FIFO_TX0, SCI_FIFO_RX1);
	SCI_enableInterrupt(sci_base, SCI_RX_DATA_AVAILABLE_INT);
	SCI_ClearReset(sci_base);
}

void sci_cfg_init(SCI_TxMsgCfg_t *pSciTxMsg)
{
	pSciTxMsg->TxIndex = 0;
	pSciTxMsg->TxLen = 0;
}

void sci_start_transmit(SCI_TxMsgCfg_t *pSciTxMsg, uint8_t *pSrcBuf, uint32_t len, uint32_t sci_base)
{
	uint32_t i;
	for(i = 0; i<len; i++)
	{
		pSciTxMsg->TxBuf[i] = pSrcBuf[i];
	}
	pSciTxMsg->TxLen = len;
	pSciTxMsg->TxIndex = 0;
	SCI_enableInterrupt(sci_base, SCI_TX_EMPTY_INT);
}

void sci_run_transmit(SCI_TxMsgCfg_t *pSciTxMsg, uint32_t sci_base)
{
	if(pSciTxMsg->TxLen == 0)
	{
		pSciTxMsg->TxIndex = 0;
		return;
	}

	if(pSciTxMsg->TxIndex == pSciTxMsg->TxLen)
	{
		SCI_disableInterrupt(sci_base, SCI_TX_EMPTY_INT);
		pSciTxMsg->TxIndex = 0;
		pSciTxMsg->TxLen = 0;
		return;
	}
	SCI_writeCharNonBlocking(sci_base, pSciTxMsg->TxBuf[pSciTxMsg->TxIndex]);
	pSciTxMsg->TxIndex++;
}

void sci_start_receive(SCI_RxMsgCfg_t *pSciRxMsg, uint32_t len, uint32_t sci_base)
{
	uint32_t i;

	if((pSciRxMsg->RxLen > 0) && (pSciRxMsg->RxIndex != pSciRxMsg->RxLen))
		return;

	pSciRxMsg->RxLen = len;
	pSciRxMsg->RxIndex = 0;
	memset(&pSciRxMsg->RxBuf[0], 0, len*2);
	//SCI_enableInterrupt(sci_base, SCI_RX_DATA_AVAILABLE_INT);
}

void sci_run_receive(SCI_RxMsgCfg_t *pSciRxMsg, uint8_t rxChar)
{
	if(pSciRxMsg->RxLen == 0)
	{
		pSciRxMsg->RxIndex = 0;
		return;
	}

	pSciRxMsg->RxBuf[pSciRxMsg->RxIndex] = rxChar;
	pSciRxMsg->RxIndex++;

	if(pSciRxMsg->RxLen == pSciRxMsg->RxIndex)
	{
		for(uint32_t i=0; i<pSciRxMsg->RxLen; i++)
			myRxBuf[i] = pSciRxMsg->RxBuf[i];
		pSciRxMsg->RxIndex = 0;
		pSciRxMsg->RxLen = 0;
		return;
	}
}

volatile uint32_t scia_int_cause;
__INTERRUPT void SCIA_ISR(void)
{
	uint32_t sci_base = SCIA_BASE;
	Uint16 sci_rxtemp;
	scia_int_cause = SCI_getInterruptCause(sci_base);
	if((scia_int_cause == SCI_RX_DATA_AVAILABLE) || (scia_int_cause == SCI_CHARACTER_TIMEOUT))
	{
		sci_rxtemp = SCI_readCharNonBlocking(sci_base);
		OSISREventSend(cPrioTask3, 1);	//event ID 1
	} else if(scia_int_cause == SCI_RX_LINE_STATUS)
	{
		SCI_clearInterruptFlag(sci_base, SCI_RX_LINE_STATUS);
	} else if(scia_int_cause == SCI_THR_EMPTY)
	{
		sci_run_transmit(&SCI_TxMsg, sci_base);
	}

}

volatile uint32_t scib_int_cause;
__INTERRUPT void SCIB_ISR(void)
{
	uint32_t sci_base = SCIB_BASE;
	Uint16 sci_rxtemp;
	scib_int_cause = SCI_getInterruptCause(sci_base);
	if((scib_int_cause == SCI_RX_DATA_AVAILABLE) || (scib_int_cause == SCI_CHARACTER_TIMEOUT))
	{
//		sci_rxtemp = SCI_readCharNonBlocking(sci_base);
//		sci_run_receive(&SCI_RxMsg, sci_rxtemp);
		while(SCI_isDataAvailable(sci_base)){
			sci_rxtemp = SCI_readCharNonBlocking(sci_base);
			sci_run_receive(&SCI_RxMsg, sci_rxtemp);
		}
		OSISREventSend(cPrioTask4, 2);	//event ID 1
	} else if(scib_int_cause == SCI_RX_LINE_STATUS)
	{
		SCI_clearInterruptFlag(sci_base, SCI_RX_LINE_STATUS);
	} else if(scib_int_cause == SCI_THR_EMPTY)
	{
		sci_run_transmit(&SCI_TxMsg, sci_base);
	}
}

