#include "xbar_test.h"
#include "printf.h"

/*************test cpu interrupt*************** */

//void Inputxbar_test_func(void);

uint32_t cpu_intr_ori[16]=
{
    INT_XINT1,
    INT_XINT2,
    INT_XINT3,
    INT_XINT4,
    INT_XINT5,
    INT_XINT6,
    INT_XINT7,
    INT_XINT8,
    INT_XINT9,
    INT_XINT10,
    INT_XINT11,
    INT_XINT12,
    INT_XINT13,
    INT_XINT14,
    INT_XINT15,
    INT_XINT16
};

typedef void(*interrupt_func_ptr)(void);

uint32_t intr_num[16]={0};

volatile uint32_t intr_cnt=0;

static void cpu_intr(uint8_t id)
{
	intr_num[intr_cnt++]=id;
	 XBAR_setInputPin(INPUTXBAR_BASE,id,0);
    Interrupt_enable(cpu_intr_ori[id]);
    __disable_irq();
    printf("step into cpu x=%dinterrupt\r\n  ",id);
}

void Cpu_xint0_func(void) {cpu_intr(0);}
void Cpu_xint1_func(void) {cpu_intr(1);}
void Cpu_xint2_func(void) {cpu_intr(2);}
void Cpu_xint3_func(void) {cpu_intr(3);}
void Cpu_xint4_func(void) {cpu_intr(4);}
void Cpu_xint5_func(void) {cpu_intr(5);}
void Cpu_xint6_func(void) {cpu_intr(6);}
void Cpu_xint7_func(void) {cpu_intr(7);}
void Cpu_xint8_func(void) {cpu_intr(8);}
void Cpu_xint9_func(void) {cpu_intr(9);}
void Cpu_xint10_func(void) {cpu_intr(10);}
void Cpu_xint11_func(void) {cpu_intr(11);}
void Cpu_xint12_func(void) {cpu_intr(12);}
void Cpu_xint13_func(void) {cpu_intr(13);}
void Cpu_xint14_func(void) {cpu_intr(14);}
void Cpu_xint15_func(void) {cpu_intr(15);}

const interrupt_func_ptr cpu_intr_arr[16]=
{
    &Cpu_xint0_func,
    &Cpu_xint1_func,
    &Cpu_xint2_func,
    &Cpu_xint3_func,
    &Cpu_xint4_func,
    &Cpu_xint5_func,
    &Cpu_xint6_func,
    &Cpu_xint7_func,
    &Cpu_xint8_func,
    &Cpu_xint9_func,
    &Cpu_xint10_func,
    &Cpu_xint11_func,
    &Cpu_xint12_func,
    &Cpu_xint13_func,
    &Cpu_xint14_func,
    &Cpu_xint15_func
};

uint32_t xbar_flag_arr[16]=
{
    XBAR_INPUT_FLG_XBAR_INPUT_SEL1_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL2_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL3_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL4_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL5_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL6_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL7_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL8_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL9_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL10_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL11_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL12_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL13_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL14_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL15_OUT,
    XBAR_INPUT_FLG_XBAR_INPUT_SEL16_OUT
};


/**
 * @brief test gpio--->inputxbar--->CPU INT
 * 
 */
//void Inputxbar_test_func(void)
//{
//    uint8_t i;
//    volatile uint32_t xbar_flag=0;
//    volatile uint32_t xbar_Flags=0;
//
//	GPIO_setPadConfig(3, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(3, GPIO_QUAL_ASYNC);
//	GPIO_setDirectionMode(3, GPIO_DIR_MODE_IN);
//
//    GPIO_setPinConfig(GPIO_1_GPIO1);     //gpio
//	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(1, GPIO_QUAL_ASYNC);
//	GPIO_setDirectionMode(1, GPIO_DIR_MODE_OUT);
//    GPIO_enableWritePin(1);
//    GPIO_writePin(1,0);
//
//
//
//    for ( i = 0; i < 16; i++)
//    {
//        XBAR_setInputPin(INPUTXBAR_BASE,i,3);
//        Interrupt_register(cpu_intr_ori[i], cpu_intr_arr[i]);
//        Interrupt_enable(cpu_intr_ori[i]);
//        __enable_irq();
//        DEVICE_DELAY_US(1);
//        GPIO_writePin(1,1);
//        DEVICE_DELAY_US(1);
//        GPIO_writePin(1,0);
//
//        xbar_flag=XBAR_getInputFlagStatus(xbar_flag_arr[i]);
//        xbar_Flags|=(xbar_flag<<i);
//    }
//    printf("xbar flags is %x\r\n",xbar_Flags);
//    for ( i = 0; i < 16; i++)
//    {
//        XBAR_clearInputFlag(xbar_flag_arr[i]);
//        xbar_flag=XBAR_getInputFlagStatus(xbar_flag_arr[i]);
//        xbar_Flags&=(xbar_flag<<i);
//    }
//    printf("xbar flags is %x\r\n",xbar_Flags);
//
//}

void main(void)
{
	Device_init();
	UartPrint_init(LOG_SCI_BASE, 115200);
    uint8_t i;
    volatile uint32_t xbar_flag=0;
    volatile uint32_t xbar_Flags=0;

	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(1, GPIO_QUAL_ASYNC);
	GPIO_setDirectionMode(1, GPIO_DIR_MODE_IN);

    GPIO_setPinConfig(GPIO_2_GPIO2);     //gpio
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_ASYNC);
	GPIO_setDirectionMode(2, GPIO_DIR_MODE_OUT);
    GPIO_enableWritePin(2);
    GPIO_writePin(2,0);


    for ( i = 0; i < 16; i++)
    {
        XBAR_setInputPin(INPUTXBAR_BASE,i,1);
        Interrupt_register(cpu_intr_ori[i], cpu_intr_arr[i]);
        Interrupt_enable(cpu_intr_ori[i]);
        __enable_irq();
        DEVICE_DELAY_US(1000);
        GPIO_writePin(2,1);
        DEVICE_DELAY_US(1000);
        GPIO_writePin(2,0);

        xbar_flag=XBAR_getInputFlagStatus(xbar_flag_arr[i]);
        xbar_Flags|=(xbar_flag<<i);
    }
    printf("xbar flags is %x\r\n",xbar_Flags);
    for ( i = 0; i < 16; i++)
    {
        XBAR_clearInputFlag(xbar_flag_arr[i]);
        xbar_flag=XBAR_getInputFlagStatus(xbar_flag_arr[i]);
        xbar_Flags&=(xbar_flag<<i);
    }
    printf("xbar flags is %x\r\n",xbar_Flags);


    while(1);

}
