//#############################################################################
//
// FILE:   clb_ex2_gpio_input_filter.c
//
// TITLE:  CLB Auxilary PWM.
//
//!
//! This example configures a CLB tile as an auxiliary PWM generator. The
//! example uses combinatorial logic (LUTs), state machines (FSMs), counters,
//! and the high level controller (HLC) to demonstrate the PWM output generation
//! capabilities using CLB.
#include "board_cfg.h"

#include "printf.h"
#include "board.h"

#define EDA_CSIM                  0             //set to 1 when make target for simulation
uint32_t ccount = 0UL;
uint16_t cglitch = 3U;

int main(void)
{

    Device_init();

	__enable_irq();

	Board_init();


	CLB_setGPREG(myTILE1_BASE, 0x1);


       while(1)
       {
    	   if (ccount++ > 10000U)
    	           {
    	               EPWM_setCounterCompareValue (EPWM1_BASE, EPWM_COUNTER_COMPARE_A, cglitch);
    	               EPWM_setCounterCompareValue (EPWM1_BASE, EPWM_COUNTER_COMPARE_B, cglitch);
    	               ccount = 0;
    	           }
       }


    return 0;
}

