/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    main.c
*   @brief
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "printf.h"
#include "device.h"
#include "cmpss_ex4_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/**
  * \brief  Main program
  * \param  None
  * \retval None
  */
int main(void)
{
	Device_init();

	UartPrint_init(LOG_SCI_BASE, 115200);
	printf("cmpss1\r\n");

    //
    // Board initialization
    // - Configure GPIO4 to output CTRIPOUT1H (routed through XBAROUTPUT3)
    // - Setup the Output X-BAR to output CTRIPOUTH on OUTPUTXBAR3
    // - Configure the high comparator of CMPSS1
    // - Enable CMPSS and configure the negative input signal to come from
    //   the DAC
    // - Use VDDA as the reference for the DAC and set DAC value to midpoint for
    //   arbitrary reference.
    // - Configure digital filter. For this example, the maxiumum values will be
    //   used for the clock prescale, sample window size, and threshold.
    // - Initialize the filter logic and start filtering
    // - Configure the output signals. Both CTRIPH and CTRIPOUTH will be fed by
    //   the filter output.
    //
    Board_init();

    // Set up ePWM7 to take CTRIPH as TRIP4 for its DC trip input
    initEPWM();

    EPWM_setHrpwmDllCfg0(myPREEPWM,HRPWM_0CFG_VALUE);
    EPWM_setHrpwmDllCfg0(myPREEPWM,HRPWM_1CFG_VALUE);

    // Configure GPIO13 to output CTRIPH (routed through ePWM TRIP4 and ePWM7B)/EPWM7A Normal Output
    GPIO_setPinConfig(GPIO_0_EPWM1_A);
    GPIO_setPinConfig(GPIO_1_EPWM1_B);

    // Loop indefinitely
    while(1)
    {
        //
        // Trip flag is set when CTRIP signal is asserted
        //
    	if((EPwm1Regs.TZFLG.bit.OST & EPWM_TZ_FLAG) != 0U)
    	{
            // Wait for comparator CTRIP to de-assert
            while((Cmpss1Regs.COMPSTS.bit.COMPHSTS & CMPSS_STS_HI_FILTOUT) != 0U)
            {
            	;
            }

            // Clear trip flags
            EPwm1Regs.TZCLR.bit.INT =  TZCLR_FLAG;
            EPwm1Regs.TZCLR.bit.OST =  TZCLR_FLAG;
        }
    }
  /* We should never get here as control is now taken by the scheduler */
  for(;;);
}

// initEPWM - Function to configure ePWM7 and the ePWM X-BAR to take CTRIPH as
//            the DC trip input
void initEPWM(void)
{
	// Sync the ePWM time base clock
	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

	// Configure TRIP4 to be CTRIP1H using the ePWM X-BAR
	XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX00_CMPSS1_CTRIPH);
	XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX00);

	// Set the time base clock prescalers to /1
	EPWM_setClockPrescaler(EPWM1_BASE, EPWM_CLOCK_DIVIDER_1,
						   EPWM_HSCLOCK_DIVIDER_1);

	// Initializing dummy values for ePWM counter and period
	EPWM_setTimeBaseCounter(EPWM1_BASE, 0);
	EPWM_setTimeBasePeriod(EPWM1_BASE, 0x9000);

	// Set-up compare
	EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, 0x8000);
	EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, 0x7FFF);
	EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);

	// Set actions
	EPWM_setActionQualifierAction(EPWM1_BASE,
								  EPWM_AQ_OUTPUT_B,
								  EPWM_AQ_OUTPUT_HIGH,
								  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);

	EPWM_setActionQualifierAction(EPWM1_BASE,
								  EPWM_AQ_OUTPUT_B,
								  EPWM_AQ_OUTPUT_LOW,
								  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

	EPWM_setActionQualifierAction(EPWM1_BASE,
								  EPWM_AQ_OUTPUT_A,
								  EPWM_AQ_OUTPUT_HIGH,
								  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);

	EPWM_setActionQualifierAction(EPWM1_BASE,
								  EPWM_AQ_OUTPUT_A,
								  EPWM_AQ_OUTPUT_LOW,
								  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

	// Put the time base counter into up-count mode
	EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP);

	// Configure ePWM1B to output high on TZB TRIP
	EPWM_setTripZoneAction(EPWM1_BASE, EPWM_TZ_ACTION_EVENT_TZB,
						   EPWM_TZ_ACTION_HIGH);

	// Trigger event when DCBH is high
	EPWM_setTripZoneDigitalCompareEventCondition(EPWM1_BASE,
												 EPWM_TZ_DC_OUTPUT_B1,
												 EPWM_TZ_EVENT_DCXH_HIGH);

	// Configure DCBH to use TRIP4 as an input
	EPWM_enableDigitalCompareTripCombinationInput(EPWM1_BASE,
												  EPWM_DC_COMBINATIONAL_TRIPIN4,
												  EPWM_DC_TYPE_DCBH);

	// Enable DCB as OST
	EPWM_enableTripZoneSignals(EPWM1_BASE, EPWM_TZ_SIGNAL_DCBEVT1);

	// Configure the DCB path to be unfiltered and asynchronous
	EPWM_setDigitalCompareEventSource(EPWM1_BASE,
									  EPWM_DC_MODULE_B,
									  EPWM_DC_EVENT_1,
									  EPWM_DC_EVENT_SOURCE_ORIG_SIGNAL);

	// Clear trip flags
	EPWM_clearTripZoneFlag(EPWM1_BASE, EPWM_TZ_INTERRUPT |
						   EPWM_TZ_FLAG_OST);
}
#ifdef __cplusplus
}
#endif

/*****END OF FILE****/
