/*
 *   Copyright (c) HPEC Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define GPIO_STA    31

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */


/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

extern void adc_test_init(void);
extern void cmpssdac_init();
/**
  * @brief  main function.
  * @param  None
  * @return None
  */
uint16_t DACA_Value = 0;
uint16_t DACC_Value = 4095;
uint16_t ADCA_Result[128];
uint16_t ADCC_Result[128];
uint32_t AdcResultIdx;
int main(void)
{
	__disable_irq();

    Device_init();

    adc_test_init();
    cmpssdac_init();

    __enable_irq();
    while (1)
    {
    	CMPSS_setDACValueLow(CMPSS2_BASE, DACA_Value);
    	CMPSS_setDACValueLow(CMPSS4_BASE, DACC_Value);

    	ADC_forceSOC(ADCA_BASE, ADC_SOC_NUMBER0);
        while(ADC_getInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1) == false);
        ADCA_Result[AdcResultIdx] = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER0);
        ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);

    	ADC_forceSOC(ADCC_BASE, ADC_SOC_NUMBER0);
        while(ADC_getInterruptStatus(ADCC_BASE, ADC_INT_NUMBER1) == false);
        ADCC_Result[AdcResultIdx] = ADC_readResult(ADCCRESULT_BASE, ADC_SOC_NUMBER0);
        ADC_clearInterruptStatus(ADCC_BASE, ADC_INT_NUMBER1);

        AdcResultIdx++;
        AdcResultIdx &= (128-1);

        DACA_Value += (4096/128);
        DACA_Value %= 4096;

        DACC_Value -= (4096/128);
        DACC_Value %= 4096;

        /* delay 3907uS for next cycle, 3907uS * 128cycles = 0.5S for one period */
        DEVICE_DELAY_US(7813/2);	// 2Hz
    }

    return 0;
}

